# Contribution guidelines

Contribution is always welcomed in WoeUSB!  However, please review the following guidelines thoroughly before contributing to make our lives easier.

## Reporting bugs

* Please check for [existing bug reports](https://github.com/WoeUSB/WoeUSB/issues?q=is%3Aissue+label%3Abug+) before attempting to file a new one.
* Be sure to check out [How To Ask Questions The Smart Way](http://www.catb.org/~esr/faqs/smart-questions.html) by [Eric Steven Raymond](http://www.catb.org/~esr/) for numerous advices to make the bug reporting experience smoother.
* Please [file an issue in the issue tracker](https://github.com/WoeUSB/WoeUSB/issues/new) and use the given bug report template to properly describe the bug.

## Requesting new features

* Please check for [existing feature requests](https://github.com/WoeUSB/WoeUSB/issues?q=is%3Aissue+label%3Aenhancement+) before attempting to file a new one.
* Please [file an issue in the issue tracker](https://github.com/WoeUSB/WoeUSB/issues/new) and use the given feature request template to properly describe the request.

## Contributing to the localization(L10N) of the product

Currently there is no internationalization(I18N) infrastructure implemented in this project, patches are welcome!

## Contributing to the documentation

* We require all contribution's revision commits to be signed with [Developer Certificate of Origin](https://developercertificate.org/).
* We require documentation to be conforming to the styling policy enforced by [EditorConfig](.editorconfig) and [Markdownlint](.markdownlint.yml).
* We require contributions to conform with the [REUSE Specification – Version 3.0](https://reuse.software/spec/), or any version that is more recent than specified.

## Contributing to the program code

* We require all contribution's revision commits to be signed with [Developer Certificate of Origin](https://developercertificate.org/).
* We require code to be conforming to the styling policy enforced by [EditorConfig](.editorconfig).
* We require contributions to conform with the [REUSE Specification – Version 3.0](https://reuse.software/spec/), or any version that is more recent than specified.

## Contributing to other aspect not mentioned here

Please [file an issue in the issue tracker](https://github.com/WoeUSB/WoeUSB/issues/new) regarding your concerns!
