---
title: "Velero 1.5: Auto volume backup with restic, DeleteItemAction plugins, Restore Hooks, and much more!"
excerpt: The community high tide raises Velero to its 1.5 release. Announcing support for backing up pod volumes using restic without annotating every pod, DeleteItemAction- a new plugin kind, Restore Hooks, and much more. It is with that pride and excitement we ship Velero 1.5.
author_name: Ashish Amarnath
slug: Velero-1.5-For-And-By-Community
categories: ['velero','release']
image: /img/posts/post-1.5.jpg
# Tag should match author to drive author pages
tags: ['Velero Team', 'Ashish Amarnath', 'Velero Release']
---

Velero continues to evolve and gain adoption in the Kubernetes community. It is with pride and excitement that we announce the release of Velero 1.5.

With new features and functionalities, like using restic to backup pod volumes without adding annotations to pods, introducing the new DeleteItemAction plugin type, supporting hooks to customize restore operations, the broad theme for this release is operational ease.

## We Stand Against Racism

Before diving into the features in this release, we would like to state explicitly that we stand in solidarity against racism and, to that effect, we have made the following changes to the Velero project:

1. We have removed insensitive language from all of our documentation including those on our website [velero.io](https://velero.io).
1. All of our repositories, including the Velero and  plugins repositories, now use `main` as their default branch.
1. The development images pushed to [Velero docker hub](https://hub.docker.com/u/velero) on every PR merge now have the `main` tag. For example, the latest development image for `velero` is `velero/velero:main`.

If we have missed addressing insensitive verbiage anywhere, please let us know on the [#velero slack channel](https://kubernetes.slack.com/archives/C6VCGP4MT) or by [creating issues on github](https://github.com/vmware-tanzu/velero/issues/new/choose) and we will address it immediately.

## Release Highlights

### Auto Volume Backup Using Restic

Prior to this release, Velero only supported opt-in behavior to backup pod volumes using restic that required users to individually annotate their pod spec with the volumes to backup up using restic. This was frequently raised in the community as a pain point and many users built automation to add the necessary annotations.

With the release of 1.5, Velero now has the ability to backup all pod volumes using restic, without having to individually annotate every pod. This feature allows users to backup all pod volumes, by default, using restic, except for:

1. Volumes mounting the default service account token
1. Hostpath volumes
1. Volumes mounting Kubernetes Secrets and ConfigMaps.

You can enable this feature on a per backup basis or as a default setting for all Velero backups. Read more about this feature on our [restic integration](https://velero.io/docs/v1.5/restic/) page on our documentation website.

### DeleteItemAction Plugins: A new way to customize Velero

Plugins in Velero are independent binaries that you can use to customize Velero’s behavior. 
In this release, we introduce a new plugin type, DeleteItemAction plugin, that offers yet another extension point to customize Velero’s functionality. This is in addition to the already existing ObjectStore plugin, VolumeSnapshotter plugin, BackupItemAction, and RestoreItemAction plugin types.

The [velero-plugin-for-csi](https://github.com/vmware-tanzu/velero-plugin-for-csi) introduced a new pattern for backing up and restoring volume snapshots using BackupItemAction and RestoreItemAction plugins. To allow the community to adopt a similar pattern for their custom resources, Velero had to provide an extension point to clean up both in-cluster and external resources, created by their BackupItemAction plugins. This is now possible with DeleteItemAction plugins. The interface for this new plugin type is similar to that of BackupItemAction and RestoreItemAction plugins. You can read more about the design for this plugin in the [design documents of our repository on github](https://github.com/vmware-tanzu/velero/blob/main/design/delete-item-action.md).

### Code Modernization

Velero has been helping its users with disaster recovery for their Kubernetes clusters since its first release in August 2017. Over the past three years, there have been major improvements in the ecosystem, including new frameworks that make it easier to develop solutions for Kubernetes. This release marks the first steps in our journey to modernize the Velero codebase and take advantage of newer frameworks as we begin the adoption of [kubebuilder](https://book.kubebuilder.io/), the most popular framework to build custom Kubernetes APIs and their respective controllers. As this effort continues, we would like to invite more folks to be a part of our growing contributor base.

Staying on the theme of using tools that are current and growing our contributor base: thanks to our community member and first-time contributor [@RobReus](https://github.com/RobReus), Velero now uses [docker buildx](https://docs.docker.com/buildx/working-with-buildx/) to build multi-arch images for Velero. You can read more about this on [our documentation website](https://velero.io/docs/main/build-from-source/#buildx) and [docker’s documentation](https://docs.docker.com/buildx/working-with-buildx/).

### Restore Hooks

Using [Velero’s Backup Hooks](https://velero.io/docs/v1.5/backup-hooks/) functionality, users can quiesce and un-quiesce applications before and after backup operations. This allows users to take application consistent backups of volume data. However, similar functionality to perform custom actions during or after a restore operation was unavailable. This led our users to build custom extensions outside of Velero as a workaround.

Driven wholly by the Velero community, we have a design for the missing Restore Hooks functionality. Thank you to our community members [@marccampbell](https://github.com/marccampbell) and [@areed](https://github.com/areed) for driving the design proposal, and to everyone who participated in the design discussions and reviews. In the design, there are two kinds of Restore Hooks:
1. InitContainer Restore Hooks: These will add init containers into restored pods to perform any necessary setup before the application containers of the restored pod can start.
1. Exec Restore Hooks: These can be used to execute custom commands or scripts in containers of a restored Kubernetes pod.

You can find more details about the design in the [design document for this feature](https://github.com/vmware-tanzu/velero/blob/main/design/restore-hooks.md).

### Ordered backup of resources

Velero can specify a custom order in which resources can be backed up. Thanks to our community member [@phuongatemc](https://github.com/phuongatemc) for driving this functionality from design to implementation. This is going to serve as a building block to support backup and restore of certain stateful applications. Here is the [design document](https://github.com/vmware-tanzu/velero/blob/main/design/backup-resources-order.md) for the enhancement.


These were just some highlights of the release. You can always find more information about the release in the [release change log](https://github.com/vmware-tanzu/velero/blob/v1.5.1/changelogs/CHANGELOG-1.5.md). 
See the [1.5 upgrade instructions](https://velero.io/docs/v1.5/upgrade-to-1.5/) to start planning your upgrade today.

## Join the Community and Make Velero Better

Velero is better because of our contributors and maintainers. It is because of you that we can bring great software to the community. Please join us during our online community meetings every Tuesday and catch up with past meetings on YouTube on the [Velero Community Meetings playlist](https://www.youtube.com/watch?v=nc48ocI-6go&list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM).

You can always find the latest project information at velero.io. Look for issues on GitHub marked Good first issue or Help wanted if you want to roll up your sleeves and write some code with us.

You can chat with us on [Kubernetes Slack in the #velero channel](https://kubernetes.slack.com/messages/C6VCGP4MT) and follow us on Twitter at [@projectvelero](https://twitter.com/projectvelero).



