---
title: "Velero 1.4: Introducing Beta CSI Support, Backup Progress Tracking, and Much More!"
excerpt: Riding a wave of community contributions, Velero 1.4 introduces beta CSI support, improvements to backup progress tracking, and more. A major focus for 1.4 was addressing issues raised by the community, and we are proud to be able to deliver improvements that matter to you.
author_name: Nolan Brubaker
slug: Velero-1.4-Community-Wave
categories: ['velero','release']
image: /img/posts/post-1.4.jpg
# Tag should match author to drive author pages
tags: ['Velero Team', 'Nolan Brubaker']
---
The Velero team is excited to announce the launch of Velero v1.4.0! This release is one of our largest since v1.0.0, with many of our new features coming from community contributors.

## Beta CSI Support

Velero v1.4.0 now extends Velero’s support for snapshotting beyond Velero’s native VolumeSnapshotter plugins to include beta support for the Kubernetes Container Storage Interface volume snapshotting capabilities.

The [Container Storage Interface](https://github.com/container-storage-interface/spec) (CSI) is a way for container orchestrators such as Kubernetes to provide a standard interface for storage systems, without having to create drivers for each orchestration system. While basic attach and detach volume operations are generally available in Kubernetes, the volume snapshotting APIs are still in beta. The Velero team is working with the Data Protection Working Group to ensure that the CSI snapshotting API specification is useful to end users and tool builders.  We intend to trail behind the official Kubernetes support for the feature, entering general availability sometime after the feature is GA in Kubernetes itself.

Activating and using the CSI support in Velero will require enabling the `EnableCSI` feature flag and installing the [CSI plugin](https://github.com/vmware-tanzu/velero-plugin-for-csi/) alongside the Velero server. For full details on installing and using the feature, see our [CSI beta page](https://velero.io/docs/csi/).

As a very brief example of the seamless integration of CSI into Velero. We will back up and restore a sample workload in the `csi-app` namespace that is using volumes backed by the CSI hostpath plugin driver. Installing and configuring the driver is outside the scope of this blog post, but we will cover the complete example in the future.

To backup this application, we run

```
$ velero backup create csi-b1 --include-namespaces csi-app --wait
Backup request "csi-b1" submitted successfully.
Waiting for backup to complete. You may safely press ctrl-c to stop waiting - your backup will continue in the background.
......
Backup completed with status: Completed. You may check for more information using the commands `velero backup describe csi-b1` and `velero backup logs csi-b1`.
```

Velero will detect the use of CSI volumes and invoke [BackupItemAction](https://github.com/vmware-tanzu/velero-plugin-for-csi#kinds-of-plugins-included) plugins that create the CSI VolumeSnapshot and VolumesnapshotContents as part of the backup.

```
$ kubectl -n csi-app get volumesnapshot,volumesnapshotcontent -lvelero.io/backup-name=csi-b1 -oname
volumesnapshot.snapshot.storage.k8s.io/velero-csi-pvc-4277g
volumesnapshotcontent.snapshot.storage.k8s.io/snapcontent-bb3266bd-d36a-4e00-9ad0-bfbb98a073dd
```

Now to restore from this backup, we run

```
$ velero create restore --from-backup csi-b1 --wait
Restore request "csi-b1-20200515112009" submitted successfully.
Waiting for restore to complete. You may safely press ctrl-c to stop waiting - your restore will continue in the background.

Restore completed with status: Completed. You may check for more information using the commands `velero restore describe csi-b1-20200515112009` and `velero restore logs csi-b1-20200515112009`.
```

Velero will detect the CSI Snapshot API objects and invoke the [RestoreItemAction](https://github.com/vmware-tanzu/velero-plugin-for-csi#kinds-of-plugins-included) plugins that create CSI VolumeSnapshotContent and statically bind to the VolumeSnapshot created during backup.

```
$ kubectl -n csi-app get volumesnapshot,volumesnapshotcontent -lvelero.io/restore-name=csi-b1-20200515112009 -oname
volumesnapshot.snapshot.storage.k8s.io/velero-csi-pvc-4277g

$ kubectl –n csi-app get volumesnapshot.snapshot.storage.k8s.io/velero-csi-pvc-4277g -ojson | jq .spec.source
{
  "volumeSnapshotContentName": "velero-velero-csi-pvc-4277g-c6nz4"
}
```

Both the current Velero VolumeSnapshotter plugins and the CSI snapshotting support will be supported for the foreseeable future.


If you want to try this out and provide feedback, please install the CSI drivers and enable this feature in your testing environments. This will help both Velero and the Kubernetes communities improve data protection for everyone!

## Backup progress tracking

One thing users have asked for is that they would like to have more information about what’s happening during long-running backup operations. We’ve heard you! With v1.4.0, we’ve started building capabilities into Velero for tracking backup progress. To begin with, Velero will track the number of Kubernetes objects that are being processed in a running backup, and that number can be observed via the `velero backup describe` command, or by retrieving the backup custom resource.

This is just the beginning. We plan to further expand on backup progress reporting in future versions of Velero, especially around volume snapshot operations.

## New Backup Tarball Format / API discovery feature flag
Since its inception, Velero has backed up and restored the Kubernetes API server’s preferred version of an API group. As Kubernetes evolves, however, this approach is causing backups to age out somewhat unexpectedly - as an example, in Kubernetes v1.16, the apps/v1beta1 API version was removed, making backups containing any Deployments in them unrestorable.

In order to remedy this, [Rafael Brito](https://github.com/brito-rafa) from VMware has tackled the issue and reworked Velero’s backup logic and format. Velero v1.4.0 introduces a backwards-compatible change to the backup tarball format, in addition to a new change to the API discovery behavior that will back up all versions of each resource, rather than just the preferred version.

We’re currently experimenting with being able to restore different versions, as well as revisiting assumptions in the backup code that are now changed by this feature. If you’d like to try it out in the meantime, you can enable it with the `EnableAPIGroupVersions` feature flag. Be sure to provide feedback on [the issue](https://github.com/vmware-tanzu/velero/issues/2551) if you interested, as well.

## Added support for custom certificates

When deploying Velero on-premises, users have often asked for supporting a custom certificate authority. With Velero v1.4.0, this is now possible! Thanks to contributions from [Samuel Lucidi](https://github.com/mansam) and [Dylan McMurray](https://github.com/dymurray) from Red Hat, Velero now supports using custom certificates for accessing object stores. For more information, please see the [documentation on custom certificates](https://velero.io/docs/v1.4/self-signed-certificates/).

## Better support for restoring custom resources from CustomResourceDefinition in the same restore operation

Some users may have noticed that when restoring a backup containing CustomResourceDefinitions, the corresponding custom resources were not always restored. However, when running another restore, everything ran successfully.

With Velero v1.4.0, we’ve revisited our Kubernetes API server group discovery code and allowed the restore code to detect CustomResourceDefinition groups as they get restored, rather simply relying on time-based refreshes.

## Refactored CRD backup code

Some users of v1beta1 CustomResourceDefinitions were seeing issues with backing up and restoring the v1beta1 CustomResourceDefinitions with the Velero v1.3.x series.

Based on the user reports, we identified errors in how v1beta1 CustomResourceDefinitions were being handled at backup time. With Velero v1.4.0, v1beta1 CustomResourceDefinitions will be backed up correctly.

## Updated container base to Ubuntu Focal Fossa

In order to keep up-to-date with our dependencies, we’ve moved our base container image from Ubuntu Bionic to Ubuntu Focal Fossa, the latest Long Term Support release that came out in April 2020. This brings our base installation more up-to-date, making it more secure and more maintainable.


## Join the Movement – Contribute!

Thanks again to all of our contributors who asked questions, filed issues, and wrote code for this release of Velero! We encourage you to try out these new features and provide feedback through our Slack channel or with an issue.

If you’d like to get involved, please join us during our [online community meetings every Tuesday](https://velero.io/community/) and catch up with past meetings on YouTube on the [Velero Community Meetings playlist](https://www.youtube.com/watch?v=nc48ocI-6go&list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM).

You can always find the latest project information at [velero.io](https://velero.io). Look for issues on GitHub marked [Good first issue](https://github.com/vmware-tanzu/velero/issues?q=is:open+is:issue+label:%22Good+first+issue%22) or [Help wanted](https://github.com/vmware-tanzu/velero/issues?utf8=✓&q=is:open+is:issue+label:%22Help+wanted%22+) if you want to roll up your sleeves and write some code with us.

You can chat with us on [Kubernetes Slack in the #velero channel](https://kubernetes.slack.com/messages/C6VCGP4MT) and follow us on Twitter at [@projectvelero](https://twitter.com/projectvelero).
