/*
Copyright The Velero Contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package mocks

import (
	"context"

	"github.com/kopia/kopia/fs"
	"github.com/stretchr/testify/mock"

	"github.com/kopia/kopia/snapshot/policy"

	"github.com/kopia/kopia/snapshot"
)

// Upload is an autogenerated mock type for the Upload type
type Uploader struct {
	mock.Mock
}

// Execute provides a mock function with given fields: ctx, source, policyTree, sourceInfo, previousManifests
func (_m *Uploader) Upload(ctx context.Context, source fs.Entry, policyTree *policy.Tree, sourceInfo snapshot.SourceInfo, previousManifests ...*snapshot.Manifest) (*snapshot.Manifest, error) {
	_va := make([]any, len(previousManifests))
	for _i := range previousManifests {
		_va[_i] = previousManifests[_i]
	}
	var _ca []any
	_ca = append(_ca, ctx, source, policyTree, sourceInfo)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *snapshot.Manifest
	if rf, ok := ret.Get(0).(func(context.Context, fs.Entry, *policy.Tree, snapshot.SourceInfo, ...*snapshot.Manifest) *snapshot.Manifest); ok {
		r0 = rf(ctx, source, policyTree, sourceInfo, previousManifests...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*snapshot.Manifest)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, fs.Entry, *policy.Tree, snapshot.SourceInfo, ...*snapshot.Manifest) error); ok {
		r1 = rf(ctx, source, policyTree, sourceInfo, previousManifests...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
