/*
Copyright The Velero Contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package mocks

import (
	"context"

	"github.com/kopia/kopia/repo/manifest"
	"github.com/kopia/kopia/snapshot"
	"github.com/stretchr/testify/mock"

	"github.com/kopia/kopia/repo"
)

// snapshot is an autogenerated mock type for the snapshot type
type Snapshot struct {
	mock.Mock
}

// LoadSnapshot provides a mock function with given fields: ctx, rep, manifestID
func (_m *Snapshot) LoadSnapshot(ctx context.Context, rep repo.Repository, manifestID manifest.ID) (*snapshot.Manifest, error) {
	ret := _m.Called(ctx, rep, manifestID)

	var r0 *snapshot.Manifest
	if rf, ok := ret.Get(0).(func(context.Context, repo.Repository, manifest.ID) *snapshot.Manifest); ok {
		r0 = rf(ctx, rep, manifestID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*snapshot.Manifest)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, repo.Repository, manifest.ID) error); ok {
		r1 = rf(ctx, rep, manifestID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveSnapshot provides a mock function with given fields: ctx, rep, man
func (_m *Snapshot) SaveSnapshot(ctx context.Context, rep repo.RepositoryWriter, man *snapshot.Manifest) (manifest.ID, error) {
	ret := _m.Called(ctx, rep, man)

	var r0 manifest.ID
	if rf, ok := ret.Get(0).(func(context.Context, repo.RepositoryWriter, *snapshot.Manifest) manifest.ID); ok {
		r0 = rf(ctx, rep, man)
	} else {
		r0 = ret.Get(0).(manifest.ID)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, repo.RepositoryWriter, *snapshot.Manifest) error); ok {
		r1 = rf(ctx, rep, man)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
