/*
Copyright The Velero Contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package mocks

import (
	"context"

	"github.com/kopia/kopia/repo/manifest"
	"github.com/kopia/kopia/snapshot/policy"
	"github.com/stretchr/testify/mock"

	"github.com/kopia/kopia/repo"

	"github.com/kopia/kopia/snapshot"
)

// policy is an autogenerated mock type for the TreeForSource type
type Policy struct {
	mock.Mock
}

// Execute provides a mock function with given fields: ctx, rep, si
func (_m *Policy) TreeForSource(ctx context.Context, rep repo.Repository, si snapshot.SourceInfo) (*policy.Tree, error) {
	ret := _m.Called(ctx, rep, si)

	var r0 *policy.Tree
	if rf, ok := ret.Get(0).(func(context.Context, repo.Repository, snapshot.SourceInfo) *policy.Tree); ok {
		r0 = rf(ctx, rep, si)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.Tree)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, repo.Repository, snapshot.SourceInfo) error); ok {
		r1 = rf(ctx, rep, si)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ApplyRetentionPolicy provides a mock function with given fields: ctx, rep, sourceInfo, reallyDelete
func (_m *Policy) ApplyRetentionPolicy(ctx context.Context, rep repo.RepositoryWriter, sourceInfo snapshot.SourceInfo, reallyDelete bool) ([]manifest.ID, error) {
	ret := _m.Called(ctx, rep, sourceInfo, reallyDelete)

	var r0 []manifest.ID
	if rf, ok := ret.Get(0).(func(context.Context, repo.RepositoryWriter, snapshot.SourceInfo, bool) []manifest.ID); ok {
		r0 = rf(ctx, rep, sourceInfo, reallyDelete)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]manifest.ID)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, repo.RepositoryWriter, snapshot.SourceInfo, bool) error); ok {
		r1 = rf(ctx, rep, sourceInfo, reallyDelete)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

func (_m *Policy) SetPolicy(ctx context.Context, rep repo.RepositoryWriter, si snapshot.SourceInfo, pol *policy.Policy) error {
	ret := _m.Called(ctx, rep, si, pol)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, repo.RepositoryWriter, snapshot.SourceInfo, *policy.Policy) error); ok {
		r0 = rf(ctx, rep, si, pol)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
