/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by mockery v2.16.0. DO NOT EDIT.

package v2

import (
	mock "github.com/stretchr/testify/mock"
	runtime "k8s.io/apimachinery/pkg/runtime"

	v1 "github.com/vmware-tanzu/velero/pkg/apis/velero/v1"

	velero "github.com/vmware-tanzu/velero/pkg/plugin/velero"
)

// BackupItemAction is an autogenerated mock type for the BackupItemAction type
type BackupItemAction struct {
	mock.Mock
}

// AppliesTo provides a mock function with given fields:
func (_m *BackupItemAction) AppliesTo() (velero.ResourceSelector, error) {
	ret := _m.Called()

	var r0 velero.ResourceSelector
	if rf, ok := ret.Get(0).(func() velero.ResourceSelector); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(velero.ResourceSelector)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Cancel provides a mock function with given fields: operationID, backup
func (_m *BackupItemAction) Cancel(operationID string, backup *v1.Backup) error {
	ret := _m.Called(operationID, backup)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, *v1.Backup) error); ok {
		r0 = rf(operationID, backup)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Execute provides a mock function with given fields: item, backup
func (_m *BackupItemAction) Execute(item runtime.Unstructured, backup *v1.Backup) (runtime.Unstructured, []velero.ResourceIdentifier, string, []velero.ResourceIdentifier, error) {
	ret := _m.Called(item, backup)

	var r0 runtime.Unstructured
	if rf, ok := ret.Get(0).(func(runtime.Unstructured, *v1.Backup) runtime.Unstructured); ok {
		r0 = rf(item, backup)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(runtime.Unstructured)
		}
	}

	var r1 []velero.ResourceIdentifier
	if rf, ok := ret.Get(1).(func(runtime.Unstructured, *v1.Backup) []velero.ResourceIdentifier); ok {
		r1 = rf(item, backup)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]velero.ResourceIdentifier)
		}
	}

	var r2 string
	if rf, ok := ret.Get(2).(func(runtime.Unstructured, *v1.Backup) string); ok {
		r2 = rf(item, backup)
	} else {
		r2 = ret.Get(2).(string)
	}

	var r3 []velero.ResourceIdentifier
	if rf, ok := ret.Get(3).(func(runtime.Unstructured, *v1.Backup) []velero.ResourceIdentifier); ok {
		r3 = rf(item, backup)
	} else {
		if ret.Get(3) != nil {
			r3 = ret.Get(3).([]velero.ResourceIdentifier)
		}
	}

	var r4 error
	if rf, ok := ret.Get(4).(func(runtime.Unstructured, *v1.Backup) error); ok {
		r4 = rf(item, backup)
	} else {
		r4 = ret.Error(4)
	}

	return r0, r1, r2, r3, r4
}

// Name provides a mock function with given fields:
func (_m *BackupItemAction) Name() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Progress provides a mock function with given fields: operationID, backup
func (_m *BackupItemAction) Progress(operationID string, backup *v1.Backup) (velero.OperationProgress, error) {
	ret := _m.Called(operationID, backup)

	var r0 velero.OperationProgress
	if rf, ok := ret.Get(0).(func(string, *v1.Backup) velero.OperationProgress); ok {
		r0 = rf(operationID, backup)
	} else {
		r0 = ret.Get(0).(velero.OperationProgress)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, *v1.Backup) error); ok {
		r1 = rf(operationID, backup)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

type mockConstructorTestingTNewBackupItemAction interface {
	mock.TestingT
	Cleanup(func())
}

// NewBackupItemAction creates a new instance of BackupItemAction. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
func NewBackupItemAction(t mockConstructorTestingTNewBackupItemAction) *BackupItemAction {
	mock := &BackupItemAction{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
