// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.2
// source: ObjectStore.proto

package generated

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ObjectStore_Init_FullMethodName               = "/generated.ObjectStore/Init"
	ObjectStore_PutObject_FullMethodName          = "/generated.ObjectStore/PutObject"
	ObjectStore_ObjectExists_FullMethodName       = "/generated.ObjectStore/ObjectExists"
	ObjectStore_GetObject_FullMethodName          = "/generated.ObjectStore/GetObject"
	ObjectStore_ListCommonPrefixes_FullMethodName = "/generated.ObjectStore/ListCommonPrefixes"
	ObjectStore_ListObjects_FullMethodName        = "/generated.ObjectStore/ListObjects"
	ObjectStore_DeleteObject_FullMethodName       = "/generated.ObjectStore/DeleteObject"
	ObjectStore_CreateSignedURL_FullMethodName    = "/generated.ObjectStore/CreateSignedURL"
)

// ObjectStoreClient is the client API for ObjectStore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ObjectStoreClient interface {
	Init(ctx context.Context, in *ObjectStoreInitRequest, opts ...grpc.CallOption) (*Empty, error)
	PutObject(ctx context.Context, opts ...grpc.CallOption) (ObjectStore_PutObjectClient, error)
	ObjectExists(ctx context.Context, in *ObjectExistsRequest, opts ...grpc.CallOption) (*ObjectExistsResponse, error)
	GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (ObjectStore_GetObjectClient, error)
	ListCommonPrefixes(ctx context.Context, in *ListCommonPrefixesRequest, opts ...grpc.CallOption) (*ListCommonPrefixesResponse, error)
	ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error)
	DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*Empty, error)
	CreateSignedURL(ctx context.Context, in *CreateSignedURLRequest, opts ...grpc.CallOption) (*CreateSignedURLResponse, error)
}

type objectStoreClient struct {
	cc grpc.ClientConnInterface
}

func NewObjectStoreClient(cc grpc.ClientConnInterface) ObjectStoreClient {
	return &objectStoreClient{cc}
}

func (c *objectStoreClient) Init(ctx context.Context, in *ObjectStoreInitRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, ObjectStore_Init_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *objectStoreClient) PutObject(ctx context.Context, opts ...grpc.CallOption) (ObjectStore_PutObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &ObjectStore_ServiceDesc.Streams[0], ObjectStore_PutObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &objectStorePutObjectClient{stream}
	return x, nil
}

type ObjectStore_PutObjectClient interface {
	Send(*PutObjectRequest) error
	CloseAndRecv() (*Empty, error)
	grpc.ClientStream
}

type objectStorePutObjectClient struct {
	grpc.ClientStream
}

func (x *objectStorePutObjectClient) Send(m *PutObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *objectStorePutObjectClient) CloseAndRecv() (*Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *objectStoreClient) ObjectExists(ctx context.Context, in *ObjectExistsRequest, opts ...grpc.CallOption) (*ObjectExistsResponse, error) {
	out := new(ObjectExistsResponse)
	err := c.cc.Invoke(ctx, ObjectStore_ObjectExists_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *objectStoreClient) GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (ObjectStore_GetObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &ObjectStore_ServiceDesc.Streams[1], ObjectStore_GetObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &objectStoreGetObjectClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ObjectStore_GetObjectClient interface {
	Recv() (*Bytes, error)
	grpc.ClientStream
}

type objectStoreGetObjectClient struct {
	grpc.ClientStream
}

func (x *objectStoreGetObjectClient) Recv() (*Bytes, error) {
	m := new(Bytes)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *objectStoreClient) ListCommonPrefixes(ctx context.Context, in *ListCommonPrefixesRequest, opts ...grpc.CallOption) (*ListCommonPrefixesResponse, error) {
	out := new(ListCommonPrefixesResponse)
	err := c.cc.Invoke(ctx, ObjectStore_ListCommonPrefixes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *objectStoreClient) ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error) {
	out := new(ListObjectsResponse)
	err := c.cc.Invoke(ctx, ObjectStore_ListObjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *objectStoreClient) DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, ObjectStore_DeleteObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *objectStoreClient) CreateSignedURL(ctx context.Context, in *CreateSignedURLRequest, opts ...grpc.CallOption) (*CreateSignedURLResponse, error) {
	out := new(CreateSignedURLResponse)
	err := c.cc.Invoke(ctx, ObjectStore_CreateSignedURL_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ObjectStoreServer is the server API for ObjectStore service.
// All implementations should embed UnimplementedObjectStoreServer
// for forward compatibility
type ObjectStoreServer interface {
	Init(context.Context, *ObjectStoreInitRequest) (*Empty, error)
	PutObject(ObjectStore_PutObjectServer) error
	ObjectExists(context.Context, *ObjectExistsRequest) (*ObjectExistsResponse, error)
	GetObject(*GetObjectRequest, ObjectStore_GetObjectServer) error
	ListCommonPrefixes(context.Context, *ListCommonPrefixesRequest) (*ListCommonPrefixesResponse, error)
	ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error)
	DeleteObject(context.Context, *DeleteObjectRequest) (*Empty, error)
	CreateSignedURL(context.Context, *CreateSignedURLRequest) (*CreateSignedURLResponse, error)
}

// UnimplementedObjectStoreServer should be embedded to have forward compatible implementations.
type UnimplementedObjectStoreServer struct {
}

func (UnimplementedObjectStoreServer) Init(context.Context, *ObjectStoreInitRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Init not implemented")
}
func (UnimplementedObjectStoreServer) PutObject(ObjectStore_PutObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method PutObject not implemented")
}
func (UnimplementedObjectStoreServer) ObjectExists(context.Context, *ObjectExistsRequest) (*ObjectExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ObjectExists not implemented")
}
func (UnimplementedObjectStoreServer) GetObject(*GetObjectRequest, ObjectStore_GetObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method GetObject not implemented")
}
func (UnimplementedObjectStoreServer) ListCommonPrefixes(context.Context, *ListCommonPrefixesRequest) (*ListCommonPrefixesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCommonPrefixes not implemented")
}
func (UnimplementedObjectStoreServer) ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjects not implemented")
}
func (UnimplementedObjectStoreServer) DeleteObject(context.Context, *DeleteObjectRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObject not implemented")
}
func (UnimplementedObjectStoreServer) CreateSignedURL(context.Context, *CreateSignedURLRequest) (*CreateSignedURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSignedURL not implemented")
}

// UnsafeObjectStoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ObjectStoreServer will
// result in compilation errors.
type UnsafeObjectStoreServer interface {
	mustEmbedUnimplementedObjectStoreServer()
}

func RegisterObjectStoreServer(s grpc.ServiceRegistrar, srv ObjectStoreServer) {
	s.RegisterService(&ObjectStore_ServiceDesc, srv)
}

func _ObjectStore_Init_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ObjectStoreInitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).Init(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_Init_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).Init(ctx, req.(*ObjectStoreInitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ObjectStore_PutObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ObjectStoreServer).PutObject(&objectStorePutObjectServer{stream})
}

type ObjectStore_PutObjectServer interface {
	SendAndClose(*Empty) error
	Recv() (*PutObjectRequest, error)
	grpc.ServerStream
}

type objectStorePutObjectServer struct {
	grpc.ServerStream
}

func (x *objectStorePutObjectServer) SendAndClose(m *Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *objectStorePutObjectServer) Recv() (*PutObjectRequest, error) {
	m := new(PutObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ObjectStore_ObjectExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ObjectExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).ObjectExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_ObjectExists_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).ObjectExists(ctx, req.(*ObjectExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ObjectStore_GetObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetObjectRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ObjectStoreServer).GetObject(m, &objectStoreGetObjectServer{stream})
}

type ObjectStore_GetObjectServer interface {
	Send(*Bytes) error
	grpc.ServerStream
}

type objectStoreGetObjectServer struct {
	grpc.ServerStream
}

func (x *objectStoreGetObjectServer) Send(m *Bytes) error {
	return x.ServerStream.SendMsg(m)
}

func _ObjectStore_ListCommonPrefixes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCommonPrefixesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).ListCommonPrefixes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_ListCommonPrefixes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).ListCommonPrefixes(ctx, req.(*ListCommonPrefixesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ObjectStore_ListObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).ListObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_ListObjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).ListObjects(ctx, req.(*ListObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ObjectStore_DeleteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).DeleteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_DeleteObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).DeleteObject(ctx, req.(*DeleteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ObjectStore_CreateSignedURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSignedURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObjectStoreServer).CreateSignedURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ObjectStore_CreateSignedURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObjectStoreServer).CreateSignedURL(ctx, req.(*CreateSignedURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ObjectStore_ServiceDesc is the grpc.ServiceDesc for ObjectStore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ObjectStore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "generated.ObjectStore",
	HandlerType: (*ObjectStoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Init",
			Handler:    _ObjectStore_Init_Handler,
		},
		{
			MethodName: "ObjectExists",
			Handler:    _ObjectStore_ObjectExists_Handler,
		},
		{
			MethodName: "ListCommonPrefixes",
			Handler:    _ObjectStore_ListCommonPrefixes_Handler,
		},
		{
			MethodName: "ListObjects",
			Handler:    _ObjectStore_ListObjects_Handler,
		},
		{
			MethodName: "DeleteObject",
			Handler:    _ObjectStore_DeleteObject_Handler,
		},
		{
			MethodName: "CreateSignedURL",
			Handler:    _ObjectStore_CreateSignedURL_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PutObject",
			Handler:       _ObjectStore_PutObject_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetObject",
			Handler:       _ObjectStore_GetObject_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ObjectStore.proto",
}
