/*
Copyright 2018, 2019 the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package common

import (
	"github.com/sirupsen/logrus"
)

type PluginBase struct {
	ClientLogger logrus.FieldLogger
	*ServerMux
}

func NewPluginBase(options ...PluginOption) *PluginBase {
	base := new(PluginBase)
	for _, option := range options {
		option(base)
	}
	return base
}

type PluginOption func(base *PluginBase)

func ClientLogger(logger logrus.FieldLogger) PluginOption {
	return func(base *PluginBase) {
		base.ClientLogger = logger
	}
}

func ServerLogger(logger logrus.FieldLogger) PluginOption {
	return func(base *PluginBase) {
		base.ServerMux = NewServerMux(logger)
	}
}
