/*
Copyright The Velero Contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"fmt"
	"os"
	"time"
)

const (
	// workingModePause indicates it is for general purpose to hold the pod under running state
	workingModePause = "pause"
)

func main() {
	if len(os.Args) < 2 {
		fmt.Fprintln(os.Stderr, "ERROR: at least one argument must be provided, the working mode")
		os.Exit(1)
	}

	switch os.Args[1] {
	case workingModePause:
		time.Sleep(time.Duration(1<<63 - 1))
	default:
		fmt.Fprintln(os.Stderr, "ERROR: wrong working mode provided")
		os.Exit(1)
	}
}
