/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface TransitImportKeyRequest
 */
export interface TransitImportKeyRequest {
    /**
     * Enables taking a backup of the named key in plaintext format. Once set, this cannot be disabled.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    allowPlaintextBackup?: boolean;
    /**
     * True if the imported key may be rotated within Vault; false otherwise.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    allowRotation?: boolean;
    /**
     * Amount of time the key should live before being automatically rotated. A value of 0 (default) disables automatic rotation for the key.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    autoRotatePeriod?: string;
    /**
     * The base64-encoded ciphertext of the keys. The AES key should be encrypted using OAEP with the wrapping key and then concatenated with the import key, wrapped by the AES key.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    ciphertext?: string;
    /**
     * Base64 encoded context for key derivation. When reading a key with key derivation enabled, if the key type supports public keys, this will return the public key for the given context.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    context?: string;
    /**
     * Enables key derivation mode. This allows for per-transaction unique keys for encryption operations.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    derived?: boolean;
    /**
     * Enables keys to be exportable. This allows for all the valid keys in the key ring to be exported.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    exportable?: boolean;
    /**
     * The hash function used as a random oracle in the OAEP wrapping of the user-generated, ephemeral AES key. Can be one of "SHA1", "SHA224", "SHA256" (default), "SHA384", or "SHA512"
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    hashFunction?: string;
    /**
     * The plaintext PEM public key to be imported. If "ciphertext" is set, this field is ignored.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    publicKey?: string;
    /**
     * The type of key being imported. Currently, "aes128-gcm96" (symmetric), "aes256-gcm96" (symmetric), "ecdsa-p256" (asymmetric), "ecdsa-p384" (asymmetric), "ecdsa-p521" (asymmetric), "ed25519" (asymmetric), "rsa-2048" (asymmetric), "rsa-3072" (asymmetric), "rsa-4096" (asymmetric), "ml-dsa-44 (asymmetric)", "ml-dsa-65 (asymmetric)", "ml-dsa-87 (asymmetric)", "hmac", "aes128-cmac", "aes256-cmac" are supported. Defaults to "aes256-gcm96".
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    type?: string;
}

/**
 * Check if a given object implements the TransitImportKeyRequest interface.
 */
export function instanceOfTransitImportKeyRequest(value: object): value is TransitImportKeyRequest {
    return true;
}

export function TransitImportKeyRequestFromJSON(json: any): TransitImportKeyRequest {
    return TransitImportKeyRequestFromJSONTyped(json, false);
}

export function TransitImportKeyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitImportKeyRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'allowPlaintextBackup': json['allow_plaintext_backup'] == null ? undefined : json['allow_plaintext_backup'],
        'allowRotation': json['allow_rotation'] == null ? undefined : json['allow_rotation'],
        'autoRotatePeriod': json['auto_rotate_period'] == null ? undefined : json['auto_rotate_period'],
        'ciphertext': json['ciphertext'] == null ? undefined : json['ciphertext'],
        'context': json['context'] == null ? undefined : json['context'],
        'derived': json['derived'] == null ? undefined : json['derived'],
        'exportable': json['exportable'] == null ? undefined : json['exportable'],
        'hashFunction': json['hash_function'] == null ? undefined : json['hash_function'],
        'publicKey': json['public_key'] == null ? undefined : json['public_key'],
        'type': json['type'] == null ? undefined : json['type'],
    };
}

export function TransitImportKeyRequestToJSON(json: any): TransitImportKeyRequest {
    return TransitImportKeyRequestToJSONTyped(json, false);
}

export function TransitImportKeyRequestToJSONTyped(value?: TransitImportKeyRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'allow_plaintext_backup': value['allowPlaintextBackup'],
        'allow_rotation': value['allowRotation'],
        'auto_rotate_period': value['autoRotatePeriod'],
        'ciphertext': value['ciphertext'],
        'context': value['context'],
        'derived': value['derived'],
        'exportable': value['exportable'],
        'hash_function': value['hashFunction'],
        'public_key': value['publicKey'],
        'type': value['type'],
    };
}

