/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface TransitEncryptRequest
 */
export interface TransitEncryptRequest {
    /**
     * When using an AEAD cipher mode, such as AES-GCM, this parameter allows passing associated data (AD/AAD) into the encryption function; this data must be passed on subsequent decryption requests but can be transited in plaintext. On successful decryption, both the ciphertext and the associated data are attested not to have been tampered with.
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    associatedData?: string;
    /**
     * Specifies a list of items to be encrypted in a single batch. When this parameter is set, if the parameters 'plaintext', 'context' and 'nonce' are also set, they will be ignored. Any batch output will preserve the order of the batch input.
     * @type {Array<object>}
     * @memberof TransitEncryptRequest
     */
    batchInput?: Array<object>;
    /**
     * Base64 encoded context for key derivation. Required if key derivation is enabled
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    context?: string;
    /**
     * This parameter will only be used when a key is expected to be created. Whether to support convergent encryption. This is only supported when using a key with key derivation enabled and will require all requests to carry both a context and 96-bit (12-byte) nonce. The given nonce will be used in place of a randomly generated nonce. As a result, when the same context and nonce are supplied, the same ciphertext is generated. It is *very important* when using this mode that you ensure that all nonces are unique for a given context. Failing to do so will severely impact the ciphertext's security.
     * @type {boolean}
     * @memberof TransitEncryptRequest
     */
    convergentEncryption?: boolean;
    /**
     * The version of the key to use for encryption. Must be 0 (for latest) or a value greater than or equal to the min_encryption_version configured on the key.
     * @type {number}
     * @memberof TransitEncryptRequest
     */
    keyVersion?: number;
    /**
     * Base64 encoded nonce value. Must be provided if convergent encryption is enabled for this key and the key was generated with Vault 0.6.1. Not required for keys created in 0.6.2+. The value must be exactly 96 bits (12 bytes) long and the user must ensure that for any given context (and thus, any given encryption key) this nonce value is **never reused**.
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    nonce?: string;
    /**
     * The padding scheme to use for decrypt. Currently only applies to RSA key types. Options are 'oaep' or 'pkcs1v15'. Defaults to 'oaep'
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    paddingScheme?: string;
    /**
     * Ordinarily, if a batch item fails to encrypt due to a bad input, but other batch items succeed, the HTTP response code is 400 (Bad Request). Some applications may want to treat partial failures differently. Providing the parameter returns the given response code integer instead of a 400 in this case. If all values fail HTTP 400 is still returned.
     * @type {number}
     * @memberof TransitEncryptRequest
     */
    partialFailureResponseCode?: number;
    /**
     * Base64 encoded plaintext value to be encrypted
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    plaintext?: string;
    /**
     * This parameter is required when encryption key is expected to be created. When performing an upsert operation, the type of key to create. Currently, "aes128-gcm96" (symmetric) and "aes256-gcm96" (symmetric) are the only types supported. Defaults to "aes256-gcm96".
     * @type {string}
     * @memberof TransitEncryptRequest
     */
    type?: string;
}

/**
 * Check if a given object implements the TransitEncryptRequest interface.
 */
export function instanceOfTransitEncryptRequest(value: object): value is TransitEncryptRequest {
    return true;
}

export function TransitEncryptRequestFromJSON(json: any): TransitEncryptRequest {
    return TransitEncryptRequestFromJSONTyped(json, false);
}

export function TransitEncryptRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitEncryptRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'associatedData': json['associated_data'] == null ? undefined : json['associated_data'],
        'batchInput': json['batch_input'] == null ? undefined : json['batch_input'],
        'context': json['context'] == null ? undefined : json['context'],
        'convergentEncryption': json['convergent_encryption'] == null ? undefined : json['convergent_encryption'],
        'keyVersion': json['key_version'] == null ? undefined : json['key_version'],
        'nonce': json['nonce'] == null ? undefined : json['nonce'],
        'paddingScheme': json['padding_scheme'] == null ? undefined : json['padding_scheme'],
        'partialFailureResponseCode': json['partial_failure_response_code'] == null ? undefined : json['partial_failure_response_code'],
        'plaintext': json['plaintext'] == null ? undefined : json['plaintext'],
        'type': json['type'] == null ? undefined : json['type'],
    };
}

export function TransitEncryptRequestToJSON(json: any): TransitEncryptRequest {
    return TransitEncryptRequestToJSONTyped(json, false);
}

export function TransitEncryptRequestToJSONTyped(value?: TransitEncryptRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'associated_data': value['associatedData'],
        'batch_input': value['batchInput'],
        'context': value['context'],
        'convergent_encryption': value['convergentEncryption'],
        'key_version': value['keyVersion'],
        'nonce': value['nonce'],
        'padding_scheme': value['paddingScheme'],
        'partial_failure_response_code': value['partialFailureResponseCode'],
        'plaintext': value['plaintext'],
        'type': value['type'],
    };
}

