/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface LdapConfigureAuthRequest
 */
export interface LdapConfigureAuthRequest {
    /**
     * Use anonymous binds when performing LDAP group searches (if true the initial credentials will still be used for the initial connection test).
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    anonymousGroupSearch?: boolean;
    /**
     * LDAP DN for searching for the user DN (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    binddn?: string;
    /**
     * LDAP password for searching for the user DN (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    bindpass?: string;
    /**
     * If true, case sensitivity will be used when comparing usernames and groups for matching policies.
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    caseSensitiveNames?: boolean;
    /**
     * CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    certificate?: string;
    /**
     * Client certificate to provide to the LDAP server, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    clientTlsCert?: string;
    /**
     * Client certificate key to provide to the LDAP server, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    clientTlsKey?: string;
    /**
     * Timeout, in seconds, when attempting to connect to the LDAP server before trying the next URL in the configuration.
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    connectionTimeout?: string;
    /**
     * Denies an unauthenticated LDAP bind request if the user's password is empty; defaults to true
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    denyNullBind?: boolean;
    /**
     * When aliases should be dereferenced on search operations. Accepted values are 'never', 'finding', 'searching', 'always'. Defaults to 'never'.
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    dereferenceAliases?: LdapConfigureAuthRequestDereferenceAliasesEnum;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * Use anonymous bind to discover the bind DN of a user (optional)
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    discoverdn?: boolean;
    /**
     * If true, matching sAMAccountName attribute values will be allowed to login when upndomain is defined.
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    enableSamaccountnameLogin?: boolean;
    /**
     * LDAP attribute to follow on objects returned by <groupfilter> in order to enumerate user group membership. Examples: "cn" or "memberOf", etc. Default: cn
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    groupattr?: string;
    /**
     * LDAP search base to use for group membership search (eg: ou=Groups,dc=example,dc=org)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    groupdn?: string;
    /**
     * Go template for querying group membership of user (optional) The template can access the following context variables: UserDN, Username Example: (&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}})) Default: (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}}))
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    groupfilter?: string;
    /**
     * Skip LDAP server SSL Certificate verification - VERY insecure (optional)
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    insecureTls?: boolean;
    /**
     * If set to a value greater than 0, the LDAP backend will use the LDAP server's paged search control to request pages of up to the given size. This can be used to avoid hitting the LDAP server's maximum result size limit. Otherwise, the LDAP backend will not use the paged search control.
     * @type {number}
     * @memberof LdapConfigureAuthRequest
     */
    maxPageSize?: number;
    /**
     * Password policy to use to rotate the root password
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    passwordPolicy?: string;
    /**
     * Timeout, in seconds, for the connection when making requests against the server before returning back an error.
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    requestTimeout?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    rotationWindow?: string;
    /**
     * Issue a StartTLS command after establishing unencrypted connection (optional)
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    starttls?: boolean;
    /**
     * Maximum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tlsMaxVersion?: LdapConfigureAuthRequestTlsMaxVersionEnum;
    /**
     * Minimum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tlsMinVersion?: LdapConfigureAuthRequestTlsMinVersionEnum;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof LdapConfigureAuthRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tokenExplicitMaxTtl?: string;
    /**
     * The maximum lifetime of the generated token
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tokenMaxTtl?: string;
    /**
     * If true, the 'default' policy will not automatically be added to generated tokens
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    tokenNoDefaultPolicy?: boolean;
    /**
     * The maximum number of times a token may be used, a value of zero means unlimited
     * @type {number}
     * @memberof LdapConfigureAuthRequest
     */
    tokenNumUses?: number;
    /**
     * If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. "24h").
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tokenPeriod?: string;
    /**
     * Comma-separated list of policies. This will apply to all tokens generated by this auth method, in addition to any configured for specific users/groups.
     * @type {Array<string>}
     * @memberof LdapConfigureAuthRequest
     */
    tokenPolicies?: Array<string>;
    /**
     * The initial ttl of the token to generate
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tokenTtl?: string;
    /**
     * The type of token to generate, service or batch
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    tokenType?: string;
    /**
     * Enables userPrincipalDomain login with [username]@UPNDomain (optional)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    upndomain?: string;
    /**
     * LDAP URL to connect to (default: ldap://127.0.0.1). Multiple URLs can be specified by concatenating them with commas; they will be tried in-order.
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    url?: string;
    /**
     * In Vault 1.1.1 a fix for handling group CN values of different cases unfortunately introduced a regression that could cause previously defined groups to not be found due to a change in the resulting name. If set true, the pre-1.1.1 behavior for matching group CNs will be used. This is only needed in some upgrade scenarios for backwards compatibility. It is enabled by default if the config is upgraded but disabled by default on new configurations.
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    usePre111GroupCnBehavior?: boolean;
    /**
     * If true, use the Active Directory tokenGroups constructed attribute of the user to find the group memberships. This will find all security groups including nested ones.
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    useTokenGroups?: boolean;
    /**
     * Attribute used for users (default: cn)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    userattr?: string;
    /**
     * LDAP domain to use for users (eg: ou=People,dc=example,dc=org)
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    userdn?: string;
    /**
     * Go template for LDAP user search filer (optional) The template can access the following context variables: UserAttr, Username Default: ({{.UserAttr}}={{.Username}})
     * @type {string}
     * @memberof LdapConfigureAuthRequest
     */
    userfilter?: string;
    /**
     * If true, sets the alias name to the username
     * @type {boolean}
     * @memberof LdapConfigureAuthRequest
     */
    usernameAsAlias?: boolean;
}

/**
* @export
* @enum {string}
*/
export enum LdapConfigureAuthRequestDereferenceAliasesEnum {
    NEVER = 'never',
    FINDING = 'finding',
    SEARCHING = 'searching',
    ALWAYS = 'always'
}
/**
* @export
* @enum {string}
*/
export enum LdapConfigureAuthRequestTlsMaxVersionEnum {
    TLS10 = 'tls10',
    TLS11 = 'tls11',
    TLS12 = 'tls12',
    TLS13 = 'tls13'
}
/**
* @export
* @enum {string}
*/
export enum LdapConfigureAuthRequestTlsMinVersionEnum {
    TLS10 = 'tls10',
    TLS11 = 'tls11',
    TLS12 = 'tls12',
    TLS13 = 'tls13'
}


/**
 * Check if a given object implements the LdapConfigureAuthRequest interface.
 */
export function instanceOfLdapConfigureAuthRequest(value: object): value is LdapConfigureAuthRequest {
    return true;
}

export function LdapConfigureAuthRequestFromJSON(json: any): LdapConfigureAuthRequest {
    return LdapConfigureAuthRequestFromJSONTyped(json, false);
}

export function LdapConfigureAuthRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): LdapConfigureAuthRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'anonymousGroupSearch': json['anonymous_group_search'] == null ? undefined : json['anonymous_group_search'],
        'binddn': json['binddn'] == null ? undefined : json['binddn'],
        'bindpass': json['bindpass'] == null ? undefined : json['bindpass'],
        'caseSensitiveNames': json['case_sensitive_names'] == null ? undefined : json['case_sensitive_names'],
        'certificate': json['certificate'] == null ? undefined : json['certificate'],
        'clientTlsCert': json['client_tls_cert'] == null ? undefined : json['client_tls_cert'],
        'clientTlsKey': json['client_tls_key'] == null ? undefined : json['client_tls_key'],
        'connectionTimeout': json['connection_timeout'] == null ? undefined : json['connection_timeout'],
        'denyNullBind': json['deny_null_bind'] == null ? undefined : json['deny_null_bind'],
        'dereferenceAliases': json['dereference_aliases'] == null ? undefined : json['dereference_aliases'],
        'disableAutomatedRotation': json['disable_automated_rotation'] == null ? undefined : json['disable_automated_rotation'],
        'discoverdn': json['discoverdn'] == null ? undefined : json['discoverdn'],
        'enableSamaccountnameLogin': json['enable_samaccountname_login'] == null ? undefined : json['enable_samaccountname_login'],
        'groupattr': json['groupattr'] == null ? undefined : json['groupattr'],
        'groupdn': json['groupdn'] == null ? undefined : json['groupdn'],
        'groupfilter': json['groupfilter'] == null ? undefined : json['groupfilter'],
        'insecureTls': json['insecure_tls'] == null ? undefined : json['insecure_tls'],
        'maxPageSize': json['max_page_size'] == null ? undefined : json['max_page_size'],
        'passwordPolicy': json['password_policy'] == null ? undefined : json['password_policy'],
        'requestTimeout': json['request_timeout'] == null ? undefined : json['request_timeout'],
        'rotationPeriod': json['rotation_period'] == null ? undefined : json['rotation_period'],
        'rotationSchedule': json['rotation_schedule'] == null ? undefined : json['rotation_schedule'],
        'rotationWindow': json['rotation_window'] == null ? undefined : json['rotation_window'],
        'starttls': json['starttls'] == null ? undefined : json['starttls'],
        'tlsMaxVersion': json['tls_max_version'] == null ? undefined : json['tls_max_version'],
        'tlsMinVersion': json['tls_min_version'] == null ? undefined : json['tls_min_version'],
        'tokenBoundCidrs': json['token_bound_cidrs'] == null ? undefined : json['token_bound_cidrs'],
        'tokenExplicitMaxTtl': json['token_explicit_max_ttl'] == null ? undefined : json['token_explicit_max_ttl'],
        'tokenMaxTtl': json['token_max_ttl'] == null ? undefined : json['token_max_ttl'],
        'tokenNoDefaultPolicy': json['token_no_default_policy'] == null ? undefined : json['token_no_default_policy'],
        'tokenNumUses': json['token_num_uses'] == null ? undefined : json['token_num_uses'],
        'tokenPeriod': json['token_period'] == null ? undefined : json['token_period'],
        'tokenPolicies': json['token_policies'] == null ? undefined : json['token_policies'],
        'tokenTtl': json['token_ttl'] == null ? undefined : json['token_ttl'],
        'tokenType': json['token_type'] == null ? undefined : json['token_type'],
        'upndomain': json['upndomain'] == null ? undefined : json['upndomain'],
        'url': json['url'] == null ? undefined : json['url'],
        'usePre111GroupCnBehavior': json['use_pre111_group_cn_behavior'] == null ? undefined : json['use_pre111_group_cn_behavior'],
        'useTokenGroups': json['use_token_groups'] == null ? undefined : json['use_token_groups'],
        'userattr': json['userattr'] == null ? undefined : json['userattr'],
        'userdn': json['userdn'] == null ? undefined : json['userdn'],
        'userfilter': json['userfilter'] == null ? undefined : json['userfilter'],
        'usernameAsAlias': json['username_as_alias'] == null ? undefined : json['username_as_alias'],
    };
}

export function LdapConfigureAuthRequestToJSON(json: any): LdapConfigureAuthRequest {
    return LdapConfigureAuthRequestToJSONTyped(json, false);
}

export function LdapConfigureAuthRequestToJSONTyped(value?: LdapConfigureAuthRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'anonymous_group_search': value['anonymousGroupSearch'],
        'binddn': value['binddn'],
        'bindpass': value['bindpass'],
        'case_sensitive_names': value['caseSensitiveNames'],
        'certificate': value['certificate'],
        'client_tls_cert': value['clientTlsCert'],
        'client_tls_key': value['clientTlsKey'],
        'connection_timeout': value['connectionTimeout'],
        'deny_null_bind': value['denyNullBind'],
        'dereference_aliases': value['dereferenceAliases'],
        'disable_automated_rotation': value['disableAutomatedRotation'],
        'discoverdn': value['discoverdn'],
        'enable_samaccountname_login': value['enableSamaccountnameLogin'],
        'groupattr': value['groupattr'],
        'groupdn': value['groupdn'],
        'groupfilter': value['groupfilter'],
        'insecure_tls': value['insecureTls'],
        'max_page_size': value['maxPageSize'],
        'password_policy': value['passwordPolicy'],
        'request_timeout': value['requestTimeout'],
        'rotation_period': value['rotationPeriod'],
        'rotation_schedule': value['rotationSchedule'],
        'rotation_window': value['rotationWindow'],
        'starttls': value['starttls'],
        'tls_max_version': value['tlsMaxVersion'],
        'tls_min_version': value['tlsMinVersion'],
        'token_bound_cidrs': value['tokenBoundCidrs'],
        'token_explicit_max_ttl': value['tokenExplicitMaxTtl'],
        'token_max_ttl': value['tokenMaxTtl'],
        'token_no_default_policy': value['tokenNoDefaultPolicy'],
        'token_num_uses': value['tokenNumUses'],
        'token_period': value['tokenPeriod'],
        'token_policies': value['tokenPolicies'],
        'token_ttl': value['tokenTtl'],
        'token_type': value['tokenType'],
        'upndomain': value['upndomain'],
        'url': value['url'],
        'use_pre111_group_cn_behavior': value['usePre111GroupCnBehavior'],
        'use_token_groups': value['useTokenGroups'],
        'userattr': value['userattr'],
        'userdn': value['userdn'],
        'userfilter': value['userfilter'],
        'username_as_alias': value['usernameAsAlias'],
    };
}

