/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface JwtConfigureRequest
 */
export interface JwtConfigureRequest {
    /**
     * The value against which to match the 'iss' claim in a JWT. Optional.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    boundIssuer?: string;
    /**
     * The default role to use if none is provided during login. If not set, a role is required during login.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    defaultRole?: string;
    /**
     * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    jwksCaPem?: string;
    /**
     * Set of JWKS Url and CA certificate (or chain of certificates) pairs. CA certificates must be in PEM format. Cannot be used with "jwks_url" or "jwks_ca_pem".
     * @type {Array<object>}
     * @memberof JwtConfigureRequest
     */
    jwksPairs?: Array<object>;
    /**
     * JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    jwksUrl?: string;
    /**
     * A list of supported signing algorithms. Defaults to RS256.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    jwtSupportedAlgs?: Array<string>;
    /**
     * A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used with "jwks_url" or "oidc_discovery_url".
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    jwtValidationPubkeys?: Array<string>;
    /**
     * Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs.
     * @type {boolean}
     * @memberof JwtConfigureRequest
     */
    namespaceInState?: boolean;
    /**
     * The OAuth Client ID configured with your OIDC provider.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcClientId?: string;
    /**
     * The OAuth Client Secret configured with your OIDC provider.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcClientSecret?: string;
    /**
     * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcDiscoveryCaPem?: string;
    /**
     * OIDC Discovery URL, without any .well-known component (base path). Cannot be used with "jwks_url" or "jwt_validation_pubkeys".
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcDiscoveryUrl?: string;
    /**
     * The response mode to be used in the OAuth2 request. Allowed values are 'query' and 'form_post'.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcResponseMode?: string;
    /**
     * The response types to request. Allowed values are 'code' and 'id_token'. Defaults to 'code'.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    oidcResponseTypes?: Array<string>;
    /**
     * Provider-specific configuration. Optional.
     * @type {object}
     * @memberof JwtConfigureRequest
     */
    providerConfig?: object;
    /**
     * A list of ASN1 OIDs of certificate extensions marked Critical that are unsupported by Vault and should be ignored. This option should very rarely be needed except in specialized PKI environments.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    unsupportedCriticalCertExtensions?: Array<string>;
}

/**
 * Check if a given object implements the JwtConfigureRequest interface.
 */
export function instanceOfJwtConfigureRequest(value: object): value is JwtConfigureRequest {
    return true;
}

export function JwtConfigureRequestFromJSON(json: any): JwtConfigureRequest {
    return JwtConfigureRequestFromJSONTyped(json, false);
}

export function JwtConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): JwtConfigureRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'boundIssuer': json['bound_issuer'] == null ? undefined : json['bound_issuer'],
        'defaultRole': json['default_role'] == null ? undefined : json['default_role'],
        'jwksCaPem': json['jwks_ca_pem'] == null ? undefined : json['jwks_ca_pem'],
        'jwksPairs': json['jwks_pairs'] == null ? undefined : json['jwks_pairs'],
        'jwksUrl': json['jwks_url'] == null ? undefined : json['jwks_url'],
        'jwtSupportedAlgs': json['jwt_supported_algs'] == null ? undefined : json['jwt_supported_algs'],
        'jwtValidationPubkeys': json['jwt_validation_pubkeys'] == null ? undefined : json['jwt_validation_pubkeys'],
        'namespaceInState': json['namespace_in_state'] == null ? undefined : json['namespace_in_state'],
        'oidcClientId': json['oidc_client_id'] == null ? undefined : json['oidc_client_id'],
        'oidcClientSecret': json['oidc_client_secret'] == null ? undefined : json['oidc_client_secret'],
        'oidcDiscoveryCaPem': json['oidc_discovery_ca_pem'] == null ? undefined : json['oidc_discovery_ca_pem'],
        'oidcDiscoveryUrl': json['oidc_discovery_url'] == null ? undefined : json['oidc_discovery_url'],
        'oidcResponseMode': json['oidc_response_mode'] == null ? undefined : json['oidc_response_mode'],
        'oidcResponseTypes': json['oidc_response_types'] == null ? undefined : json['oidc_response_types'],
        'providerConfig': json['provider_config'] == null ? undefined : json['provider_config'],
        'unsupportedCriticalCertExtensions': json['unsupported_critical_cert_extensions'] == null ? undefined : json['unsupported_critical_cert_extensions'],
    };
}

export function JwtConfigureRequestToJSON(json: any): JwtConfigureRequest {
    return JwtConfigureRequestToJSONTyped(json, false);
}

export function JwtConfigureRequestToJSONTyped(value?: JwtConfigureRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'bound_issuer': value['boundIssuer'],
        'default_role': value['defaultRole'],
        'jwks_ca_pem': value['jwksCaPem'],
        'jwks_pairs': value['jwksPairs'],
        'jwks_url': value['jwksUrl'],
        'jwt_supported_algs': value['jwtSupportedAlgs'],
        'jwt_validation_pubkeys': value['jwtValidationPubkeys'],
        'namespace_in_state': value['namespaceInState'],
        'oidc_client_id': value['oidcClientId'],
        'oidc_client_secret': value['oidcClientSecret'],
        'oidc_discovery_ca_pem': value['oidcDiscoveryCaPem'],
        'oidc_discovery_url': value['oidcDiscoveryUrl'],
        'oidc_response_mode': value['oidcResponseMode'],
        'oidc_response_types': value['oidcResponseTypes'],
        'provider_config': value['providerConfig'],
        'unsupported_critical_cert_extensions': value['unsupportedCriticalCertExtensions'],
    };
}

