/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemWriteSyncDestinationsGhNameRequest
 */
export interface SystemWriteSyncDestinationsGhNameRequest {
    /**
     * Classic or fine-grained access token to access your GitHub organization.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    accessToken?: string;
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * The user defined name of the GitHub App configuration.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    appName?: string;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * The name of the repository environment that the secrets in GitHub will be available for. Only valid when the 'secrets_location' field is set to 'repository'.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    environmentName?: string;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    granularity?: string;
    /**
     * The ID of the GitHub App installation, returned by GitHub after installing the app on your repository
     * @type {number}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    installationId?: number;
    /**
     * The name of the GitHub organization to target which owns the repositories the secrets will be available for. Only valid when 'secrets_location' is set to 'organization'.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    organizationName?: string;
    /**
     * The type of repositories in a GitHub organization to grant visibility to the secrets, between 'all', 'private', or 'selected'. If using 'selected', you must also specify the 'selected_repository_names' field. Only valid when 'secrets_location' is set to 'organization'.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    organizationVisibility?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    purge?: boolean;
    /**
     * Name of the repository where to manage secrets. For example for 'git clone github.com/acme/my-repo' the name is my-repo.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    repositoryName?: string;
    /**
     * Organization name or username the repository belongs to. For example for 'git clone github.com/acme/my-repo' the owner is acme.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    repositoryOwner?: string;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    secretNameTemplate?: string;
    /**
     * The scope of access that the secrets in GitHub will be available for, between 'organization' or 'repository'. Repository secrets are only visible on the given repository while Organization secrets are visible to as many repositories within the organization as determined by the 'organization_visibility' field. Defaults to 'repository'.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    secretsLocation?: string;
    /**
     * The list of names of all repositories within a GitHub organization to grant access to the secrets when 'organization_visibility' is set to 'selected'.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGhNameRequest
     */
    selectedRepositoryNames?: Array<string>;
}
/**
 * Check if a given object implements the SystemWriteSyncDestinationsGhNameRequest interface.
 */
export declare function instanceOfSystemWriteSyncDestinationsGhNameRequest(value: object): value is SystemWriteSyncDestinationsGhNameRequest;
export declare function SystemWriteSyncDestinationsGhNameRequestFromJSON(json: any): SystemWriteSyncDestinationsGhNameRequest;
export declare function SystemWriteSyncDestinationsGhNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemWriteSyncDestinationsGhNameRequest;
export declare function SystemWriteSyncDestinationsGhNameRequestToJSON(json: any): SystemWriteSyncDestinationsGhNameRequest;
export declare function SystemWriteSyncDestinationsGhNameRequestToJSONTyped(value?: SystemWriteSyncDestinationsGhNameRequest | null, ignoreDiscriminator?: boolean): any;
