/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemPatchSyncDestinationsAzureKvNameRequest
 */
export interface SystemPatchSyncDestinationsAzureKvNameRequest {
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * OAuth2 client id of an Azure app registration with access to the key vault.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    clientId?: string;
    /**
     * OAuth2 client secret of an Azure app registration with access to the key vault.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    clientSecret?: string;
    /**
     * Azure environment name. If not provided, AzurePublicCloud is used.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    cloud?: string;
    /**
     * Custom tags to set on the secret managed at the destination. Custom tags are merged with system tags.
     * @type {object}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    customTags?: object;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    granularity?: string;
    /**
     * URI of the Azure Key Vault to access.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    keyVaultUri?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    purge?: boolean;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    secretNameTemplate?: string;
    /**
     * List of custom tags to remove for patch requests. This field is ignored on create and update requests.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    tagsToRemove?: Array<string>;
    /**
     * Tenant id for the Azure Active Directory.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsAzureKvNameRequest
     */
    tenantId?: string;
}
/**
 * Check if a given object implements the SystemPatchSyncDestinationsAzureKvNameRequest interface.
 */
export declare function instanceOfSystemPatchSyncDestinationsAzureKvNameRequest(value: object): value is SystemPatchSyncDestinationsAzureKvNameRequest;
export declare function SystemPatchSyncDestinationsAzureKvNameRequestFromJSON(json: any): SystemPatchSyncDestinationsAzureKvNameRequest;
export declare function SystemPatchSyncDestinationsAzureKvNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemPatchSyncDestinationsAzureKvNameRequest;
export declare function SystemPatchSyncDestinationsAzureKvNameRequestToJSON(json: any): SystemPatchSyncDestinationsAzureKvNameRequest;
export declare function SystemPatchSyncDestinationsAzureKvNameRequestToJSONTyped(value?: SystemPatchSyncDestinationsAzureKvNameRequest | null, ignoreDiscriminator?: boolean): any;
