/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface RateLimitQuotasWriteRequest
 */
export interface RateLimitQuotasWriteRequest {
    /**
     * If set, when a client reaches a rate limit threshold, the client will be prohibited from any further requests until after the 'block_interval' has elapsed.
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    blockInterval?: string;
    /**
     * Attribute by which to group requests by. Valid group_by modes are: 1) "ip" that groups requests by their source IP address (group_by defaults to ip if unset); 2) "none" that groups all requests that match the rate limit quota rule together; 3) "entity_then_ip" that groups requests by their entity ID for authenticated requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not connected to an entity); and 4) "entity_then_none" which also groups requests by their entity ID when available, but the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    groupBy?: string;
    /**
     * Whether all child namespaces can inherit this namespace quota.
     * @type {boolean}
     * @memberof RateLimitQuotasWriteRequest
     */
    inheritable?: boolean;
    /**
     * The duration to enforce rate limiting for (default '1s').
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    interval?: string;
    /**
     * Path of the mount or namespace to apply the quota. A blank path configures a global quota. For example namespace1/ adds a quota to a full namespace, namespace1/auth/userpass adds a quota to userpass in namespace1.
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    path?: string;
    /**
     * The maximum number of requests in a given interval to be allowed by the quota rule. The 'rate' must be positive.
     * @type {number}
     * @memberof RateLimitQuotasWriteRequest
     */
    rate?: number;
    /**
     * Login role to apply this quota to. Note that when set, path must be configured to a valid auth method with a concept of roles.
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    role?: string;
    /**
     * Only available when using the "entity_then_ip" or "entity_then_none" group_by modes. This is the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests that contain an entity ID are subject to the "rate" field instead. Defaults to the same value as "rate".
     * @type {number}
     * @memberof RateLimitQuotasWriteRequest
     */
    secondaryRate?: number;
    /**
     * Type of the quota rule.
     * @type {string}
     * @memberof RateLimitQuotasWriteRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the RateLimitQuotasWriteRequest interface.
 */
export declare function instanceOfRateLimitQuotasWriteRequest(value: object): value is RateLimitQuotasWriteRequest;
export declare function RateLimitQuotasWriteRequestFromJSON(json: any): RateLimitQuotasWriteRequest;
export declare function RateLimitQuotasWriteRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): RateLimitQuotasWriteRequest;
export declare function RateLimitQuotasWriteRequestToJSON(json: any): RateLimitQuotasWriteRequest;
export declare function RateLimitQuotasWriteRequestToJSONTyped(value?: RateLimitQuotasWriteRequest | null, ignoreDiscriminator?: boolean): any;
