/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiWriteIssuerResponse
 */
export interface PkiWriteIssuerResponse {
    /**
     * CA Chain
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    caChain?: Array<string>;
    /**
     * Certificate
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    certificate?: string;
    /**
     * CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Delta CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether critical extension checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    disableCriticalExtensionChecks?: boolean;
    /**
     * Whether the issuer name check should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    disableNameChecks?: boolean;
    /**
     * Whether name contraint checks shoul be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    disableNameConstraintChecks?: boolean;
    /**
     * Whether max path length checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    disablePathLengthChecks?: boolean;
    /**
     * Whether or not templating is enabled for AIA fields
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    enableAiaUrlTemplating?: boolean;
    /**
     * Issuer Id
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    issuerId?: string;
    /**
     * Issuer Name
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    issuerName?: string;
    /**
     * Issuing Certificates
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    issuingCertificates?: Array<string>;
    /**
     * Key Id
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    keyId?: string;
    /**
     * Leaf Not After Behavior
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    leafNotAfterBehavior?: string;
    /**
     * Manual Chain
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    manualChain?: Array<string>;
    /**
     * OCSP Servers
     * @type {Array<string>}
     * @memberof PkiWriteIssuerResponse
     */
    ocspServers?: Array<string>;
    /**
     * Revocation Signature Alogrithm
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    revocationSignatureAlgorithm?: string;
    /**
     * Revocation time
     * @type {number}
     * @memberof PkiWriteIssuerResponse
     */
    revocationTime?: number;
    /**
     * Revocation time RFC 3339 formatted
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    revocationTimeRfc3339?: string;
    /**
     * Revoked
     * @type {boolean}
     * @memberof PkiWriteIssuerResponse
     */
    revoked?: boolean;
    /**
     * Usage
     * @type {string}
     * @memberof PkiWriteIssuerResponse
     */
    usage?: string;
}
/**
 * Check if a given object implements the PkiWriteIssuerResponse interface.
 */
export declare function instanceOfPkiWriteIssuerResponse(value: object): value is PkiWriteIssuerResponse;
export declare function PkiWriteIssuerResponseFromJSON(json: any): PkiWriteIssuerResponse;
export declare function PkiWriteIssuerResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiWriteIssuerResponse;
export declare function PkiWriteIssuerResponseToJSON(json: any): PkiWriteIssuerResponse;
export declare function PkiWriteIssuerResponseToJSONTyped(value?: PkiWriteIssuerResponse | null, ignoreDiscriminator?: boolean): any;
