/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiReadCrlConfigurationResponse
 */
export interface PkiReadCrlConfigurationResponse {
    /**
     * If set to true, enables automatic rebuilding of the CRL
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    autoRebuild?: boolean;
    /**
     * The time before the CRL expires to automatically rebuild it, when enabled. Must be shorter than the CRL expiry. Defaults to 12h.
     * @type {string}
     * @memberof PkiReadCrlConfigurationResponse
     */
    autoRebuildGracePeriod?: string;
    /**
     * Whether to enable a global, cross-cluster revocation queue. Must be used with auto_rebuild=true.
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    crossClusterRevocation?: boolean;
    /**
     * The time between delta CRL rebuilds if a new revocation has occurred. Must be shorter than the CRL expiry. Defaults to 15m.
     * @type {string}
     * @memberof PkiReadCrlConfigurationResponse
     */
    deltaRebuildInterval?: string;
    /**
     * If set to true, disables generating the CRL entirely.
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    disable?: boolean;
    /**
     * Whether to enable delta CRLs between authoritative CRL rebuilds
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    enableDelta?: boolean;
    /**
     * The amount of time the generated CRL should be valid; defaults to 72 hours
     * @type {string}
     * @memberof PkiReadCrlConfigurationResponse
     */
    expiry?: string;
    /**
     * The maximum number of entries the CRL can contain. This is meant as a guard against accidental runaway revocations overloading Vault storage. If this limit is exceeded writing the CRL will fail. If set to -1 this limit is disabled.
     * @type {number}
     * @memberof PkiReadCrlConfigurationResponse
     */
    maxCrlEntries?: number;
    /**
     * If set to true, ocsp unauthorized responses will be returned.
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    ocspDisable?: boolean;
    /**
     * The amount of time an OCSP response will be valid (controls the NextUpdate field); defaults to 12 hours
     * @type {string}
     * @memberof PkiReadCrlConfigurationResponse
     */
    ocspExpiry?: string;
    /**
     * If set to true enables global replication of revocation entries, also enabling unified versions of OCSP and CRLs if their respective features are enabled. disable for CRLs and ocsp_disable for OCSP.
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    unifiedCrl?: boolean;
    /**
     * If set to true, existing CRL and OCSP paths will return the unified CRL instead of a response based on cluster-local data
     * @type {boolean}
     * @memberof PkiReadCrlConfigurationResponse
     */
    unifiedCrlOnExistingPaths?: boolean;
}
/**
 * Check if a given object implements the PkiReadCrlConfigurationResponse interface.
 */
export declare function instanceOfPkiReadCrlConfigurationResponse(value: object): value is PkiReadCrlConfigurationResponse;
export declare function PkiReadCrlConfigurationResponseFromJSON(json: any): PkiReadCrlConfigurationResponse;
export declare function PkiReadCrlConfigurationResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiReadCrlConfigurationResponse;
export declare function PkiReadCrlConfigurationResponseToJSON(json: any): PkiReadCrlConfigurationResponse;
export declare function PkiReadCrlConfigurationResponseToJSONTyped(value?: PkiReadCrlConfigurationResponse | null, ignoreDiscriminator?: boolean): any;
