/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiPatchIssuerRequest
 */
export interface PkiPatchIssuerRequest {
    /**
     * Comma-separated list of URLs to be used for the CRL distribution points attribute. See also RFC 5280 Section 4.2.1.13.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Comma-separated list of URLs to be used for the Delta CRL distribution points attribute, also known as Freshest CRL distribution points attribute. See also RFC 5280 Section 4.2.1.15.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether critical extension checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerRequest
     */
    disableCriticalExtensionChecks?: boolean;
    /**
     * Whether the issuer name check should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerRequest
     */
    disableNameChecks?: boolean;
    /**
     * Whether name contraint checks shoul be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerRequest
     */
    disableNameConstraintChecks?: boolean;
    /**
     * Whether max path length checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerRequest
     */
    disablePathLengthChecks?: boolean;
    /**
     * Whether or not to enabling templating of the above AIA fields. When templating is enabled the special values '{{issuer_id}}', '{{cluster_path}}', '{{cluster_aia_path}}' are available, but the addresses are not checked for URL validity until issuance time. Using '{{cluster_path}}' requires /config/cluster's 'path' member to be set on all PR Secondary clusters and using '{{cluster_aia_path}}' requires /config/cluster's 'aia_path' member to be set on all PR secondary clusters.
     * @type {boolean}
     * @memberof PkiPatchIssuerRequest
     */
    enableAiaUrlTemplating?: boolean;
    /**
     * Provide a name to the generated or existing issuer, the name must be unique across all issuers and not be the reserved value 'default'
     * @type {string}
     * @memberof PkiPatchIssuerRequest
     */
    issuerName?: string;
    /**
     * Comma-separated list of URLs to be used for the issuing certificate attribute. See also RFC 5280 Section 4.2.2.1.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    issuingCertificates?: Array<string>;
    /**
     * Behavior of leaf's NotAfter fields: "err" to error if the computed NotAfter date exceeds that of this issuer; "truncate" to silently truncate to that of this issuer; or "permit" to allow this issuance to succeed (with NotAfter exceeding that of an issuer). Note that not all values will results in certificates that can be validated through the entire validity period. It is suggested to use "truncate" for intermediate CAs and "permit" only for root CAs.
     * @type {string}
     * @memberof PkiPatchIssuerRequest
     */
    leafNotAfterBehavior?: string;
    /**
     * Chain of issuer references to use to build this issuer's computed CAChain field, when non-empty.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    manualChain?: Array<string>;
    /**
     * Comma-separated list of URLs to be used for the OCSP servers attribute. See also RFC 5280 Section 4.2.2.1.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    ocspServers?: Array<string>;
    /**
     * Which x509.SignatureAlgorithm name to use for signing CRLs. This parameter allows differentiation between PKCS#1v1.5 and PSS keys and choice of signature hash algorithm. The default (empty string) value is for Go to select the signature algorithm. This can fail if the underlying key does not support the requested signature algorithm, which may not be known at modification time (such as with PKCS#11 managed RSA keys).
     * @type {string}
     * @memberof PkiPatchIssuerRequest
     */
    revocationSignatureAlgorithm?: string;
    /**
     * Comma-separated list (or string slice) of usages for this issuer; valid values are "read-only", "issuing-certificates", "crl-signing", and "ocsp-signing". Multiple values may be specified. Read-only is implicit and always set.
     * @type {Array<string>}
     * @memberof PkiPatchIssuerRequest
     */
    usage?: Array<string>;
}
/**
 * Check if a given object implements the PkiPatchIssuerRequest interface.
 */
export declare function instanceOfPkiPatchIssuerRequest(value: object): value is PkiPatchIssuerRequest;
export declare function PkiPatchIssuerRequestFromJSON(json: any): PkiPatchIssuerRequest;
export declare function PkiPatchIssuerRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiPatchIssuerRequest;
export declare function PkiPatchIssuerRequestToJSON(json: any): PkiPatchIssuerRequest;
export declare function PkiPatchIssuerRequestToJSONTyped(value?: PkiPatchIssuerRequest | null, ignoreDiscriminator?: boolean): any;
