/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiConfigureCrlRequest
 */
export interface PkiConfigureCrlRequest {
    /**
     * If set to true, enables automatic rebuilding of the CRL
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    autoRebuild?: boolean;
    /**
     * The time before the CRL expires to automatically rebuild it, when enabled. Must be shorter than the CRL expiry. Defaults to 12h.
     * @type {string}
     * @memberof PkiConfigureCrlRequest
     */
    autoRebuildGracePeriod?: string;
    /**
     * Whether to enable a global, cross-cluster revocation queue. Must be used with auto_rebuild=true.
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    crossClusterRevocation?: boolean;
    /**
     * The time between delta CRL rebuilds if a new revocation has occurred. Must be shorter than the CRL expiry. Defaults to 15m.
     * @type {string}
     * @memberof PkiConfigureCrlRequest
     */
    deltaRebuildInterval?: string;
    /**
     * If set to true, disables generating the CRL entirely.
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    disable?: boolean;
    /**
     * Whether to enable delta CRLs between authoritative CRL rebuilds
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    enableDelta?: boolean;
    /**
     * The amount of time the generated CRL should be valid; defaults to 72 hours
     * @type {string}
     * @memberof PkiConfigureCrlRequest
     */
    expiry?: string;
    /**
     * The maximum number of entries the CRL can contain. This is meant as a guard against accidental runaway revocations overloading Vault storage. If this limit is exceeded writing the CRL will fail. If set to -1 this limit is disabled.
     * @type {number}
     * @memberof PkiConfigureCrlRequest
     */
    maxCrlEntries?: number;
    /**
     * If set to true, ocsp unauthorized responses will be returned.
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    ocspDisable?: boolean;
    /**
     * The amount of time an OCSP response will be valid (controls the NextUpdate field); defaults to 12 hours
     * @type {string}
     * @memberof PkiConfigureCrlRequest
     */
    ocspExpiry?: string;
    /**
     * If set to true enables global replication of revocation entries, also enabling unified versions of OCSP and CRLs if their respective features are enabled. disable for CRLs and ocsp_disable for OCSP.
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    unifiedCrl?: boolean;
    /**
     * If set to true, existing CRL and OCSP paths will return the unified CRL instead of a response based on cluster-local data
     * @type {boolean}
     * @memberof PkiConfigureCrlRequest
     */
    unifiedCrlOnExistingPaths?: boolean;
}
/**
 * Check if a given object implements the PkiConfigureCrlRequest interface.
 */
export declare function instanceOfPkiConfigureCrlRequest(value: object): value is PkiConfigureCrlRequest;
export declare function PkiConfigureCrlRequestFromJSON(json: any): PkiConfigureCrlRequest;
export declare function PkiConfigureCrlRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiConfigureCrlRequest;
export declare function PkiConfigureCrlRequestToJSON(json: any): PkiConfigureCrlRequest;
export declare function PkiConfigureCrlRequestToJSONTyped(value?: PkiConfigureCrlRequest | null, ignoreDiscriminator?: boolean): any;
