/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface LdapConfigureRequest
 */
export interface LdapConfigureRequest {
    /**
     * Use anonymous binds when performing LDAP group searches (if true the initial credentials will still be used for the initial connection test).
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    anonymousGroupSearch?: boolean;
    /**
     * LDAP DN for searching for the user DN (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    binddn?: string;
    /**
     * LDAP password for searching for the user DN (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    bindpass?: string;
    /**
     * If true, case sensitivity will be used when comparing usernames and groups for matching policies.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    caseSensitiveNames?: boolean;
    /**
     * CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    certificate?: string;
    /**
     * Client certificate to provide to the LDAP server, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    clientTlsCert?: string;
    /**
     * Client certificate key to provide to the LDAP server, must be x509 PEM encoded (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    clientTlsKey?: string;
    /**
     * Timeout, in seconds, when attempting to connect to the LDAP server before trying the next URL in the configuration.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    connectionTimeout?: string;
    /**
     * Denies an unauthenticated LDAP bind request if the user's password is empty; defaults to true
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    denyNullBind?: boolean;
    /**
     * When aliases should be dereferenced on search operations. Accepted values are 'never', 'finding', 'searching', 'always'. Defaults to 'never'.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    dereferenceAliases?: LdapConfigureRequestDereferenceAliasesEnum;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * Use anonymous bind to discover the bind DN of a user (optional)
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    discoverdn?: boolean;
    /**
     * If true, matching sAMAccountName attribute values will be allowed to login when upndomain is defined.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    enableSamaccountnameLogin?: boolean;
    /**
     * LDAP attribute to follow on objects returned by <groupfilter> in order to enumerate user group membership. Examples: "cn" or "memberOf", etc. Default: cn
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    groupattr?: string;
    /**
     * LDAP search base to use for group membership search (eg: ou=Groups,dc=example,dc=org)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    groupdn?: string;
    /**
     * Go template for querying group membership of user (optional) The template can access the following context variables: UserDN, Username Example: (&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}})) Default: (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}}))
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    groupfilter?: string;
    /**
     * Skip LDAP server SSL Certificate verification - VERY insecure (optional)
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    insecureTls?: boolean;
    /**
     * The desired length of passwords that Vault generates.
     * @type {number}
     * @memberof LdapConfigureRequest
     * @deprecated
     */
    length?: number;
    /**
     * If set to a value greater than 0, the LDAP backend will use the LDAP server's paged search control to request pages of up to the given size. This can be used to avoid hitting the LDAP server's maximum result size limit. Otherwise, the LDAP backend will not use the paged search control.
     * @type {number}
     * @memberof LdapConfigureRequest
     */
    maxPageSize?: number;
    /**
     * The maximum password time-to-live.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    maxTtl?: string;
    /**
     * Password policy to use to generate passwords
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    passwordPolicy?: string;
    /**
     * Timeout, in seconds, for the connection when making requests against the server before returning back an error.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    requestTimeout?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    rotationWindow?: string;
    /**
     * The desired LDAP schema used when modifying user account passwords.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    schema?: string;
    /**
     * Whether to skip the 'import' rotation.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    skipStaticRoleImportRotation?: boolean;
    /**
     * Issue a StartTLS command after establishing unencrypted connection (optional)
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    starttls?: boolean;
    /**
     * Maximum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    tlsMaxVersion?: LdapConfigureRequestTlsMaxVersionEnum;
    /**
     * Minimum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    tlsMinVersion?: LdapConfigureRequestTlsMinVersionEnum;
    /**
     * The default password time-to-live.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    ttl?: string;
    /**
     * Enables userPrincipalDomain login with [username]@UPNDomain (optional)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    upndomain?: string;
    /**
     * LDAP URL to connect to (default: ldap://127.0.0.1). Multiple URLs can be specified by concatenating them with commas; they will be tried in-order.
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    url?: string;
    /**
     * In Vault 1.1.1 a fix for handling group CN values of different cases unfortunately introduced a regression that could cause previously defined groups to not be found due to a change in the resulting name. If set true, the pre-1.1.1 behavior for matching group CNs will be used. This is only needed in some upgrade scenarios for backwards compatibility. It is enabled by default if the config is upgraded but disabled by default on new configurations.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    usePre111GroupCnBehavior?: boolean;
    /**
     * If true, use the Active Directory tokenGroups constructed attribute of the user to find the group memberships. This will find all security groups including nested ones.
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    useTokenGroups?: boolean;
    /**
     * Attribute used for users (default: cn)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    userattr?: string;
    /**
     * LDAP domain to use for users (eg: ou=People,dc=example,dc=org)
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    userdn?: string;
    /**
     * Go template for LDAP user search filer (optional) The template can access the following context variables: UserAttr, Username Default: ({{.UserAttr}}={{.Username}})
     * @type {string}
     * @memberof LdapConfigureRequest
     */
    userfilter?: string;
    /**
     * If true, sets the alias name to the username
     * @type {boolean}
     * @memberof LdapConfigureRequest
     */
    usernameAsAlias?: boolean;
}
/**
* @export
* @enum {string}
*/
export declare enum LdapConfigureRequestDereferenceAliasesEnum {
    NEVER = "never",
    FINDING = "finding",
    SEARCHING = "searching",
    ALWAYS = "always"
}
/**
* @export
* @enum {string}
*/
export declare enum LdapConfigureRequestTlsMaxVersionEnum {
    TLS10 = "tls10",
    TLS11 = "tls11",
    TLS12 = "tls12",
    TLS13 = "tls13"
}
/**
* @export
* @enum {string}
*/
export declare enum LdapConfigureRequestTlsMinVersionEnum {
    TLS10 = "tls10",
    TLS11 = "tls11",
    TLS12 = "tls12",
    TLS13 = "tls13"
}
/**
 * Check if a given object implements the LdapConfigureRequest interface.
 */
export declare function instanceOfLdapConfigureRequest(value: object): value is LdapConfigureRequest;
export declare function LdapConfigureRequestFromJSON(json: any): LdapConfigureRequest;
export declare function LdapConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): LdapConfigureRequest;
export declare function LdapConfigureRequestToJSON(json: any): LdapConfigureRequest;
export declare function LdapConfigureRequestToJSONTyped(value?: LdapConfigureRequest | null, ignoreDiscriminator?: boolean): any;
