/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface EntityMergeRequest
 */
export interface EntityMergeRequest {
    /**
     * Alias IDs to keep in case of conflicting aliases. Ignored if no conflicting aliases found
     * @type {Array<string>}
     * @memberof EntityMergeRequest
     */
    conflictingAliasIdsToKeep?: Array<string>;
    /**
     * Setting this will follow the 'mine' strategy for merging MFA secrets. If there are secrets of the same type both in entities that are merged from and in entity into which all others are getting merged, secrets in the destination will be unaltered. If not set, this API will throw an error containing all the conflicts.
     * @type {boolean}
     * @memberof EntityMergeRequest
     */
    force?: boolean;
    /**
     * Entity IDs which need to get merged
     * @type {Array<string>}
     * @memberof EntityMergeRequest
     */
    fromEntityIds?: Array<string>;
    /**
     * Entity ID into which all the other entities need to get merged
     * @type {string}
     * @memberof EntityMergeRequest
     */
    toEntityId?: string;
}
/**
 * Check if a given object implements the EntityMergeRequest interface.
 */
export declare function instanceOfEntityMergeRequest(value: object): value is EntityMergeRequest;
export declare function EntityMergeRequestFromJSON(json: any): EntityMergeRequest;
export declare function EntityMergeRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): EntityMergeRequest;
export declare function EntityMergeRequestToJSON(json: any): EntityMergeRequest;
export declare function EntityMergeRequestToJSONTyped(value?: EntityMergeRequest | null, ignoreDiscriminator?: boolean): any;
