/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface ConsulWriteRoleRequest
 */
export interface ConsulWriteRoleRequest {
    /**
     * Indicates which namespace that the token will be created within. Defaults to 'default'. Available in Consul 1.7 and above.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     */
    consulNamespace?: string;
    /**
     * List of policies to attach to the token. Either "consul_policies" or "consul_roles" are required for Consul 1.5 and above, or just "consul_policies" if using Consul 1.4.
     * @type {Array<string>}
     * @memberof ConsulWriteRoleRequest
     */
    consulPolicies?: Array<string>;
    /**
     * List of Consul roles to attach to the token. Either "policies" or "consul_roles" are required for Consul 1.5 and above.
     * @type {Array<string>}
     * @memberof ConsulWriteRoleRequest
     */
    consulRoles?: Array<string>;
    /**
     * Use "ttl" instead.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     * @deprecated
     */
    lease?: string;
    /**
     * Indicates that the token should not be replicated globally and instead be local to the current datacenter. Available in Consul 1.4 and above.
     * @type {boolean}
     * @memberof ConsulWriteRoleRequest
     */
    local?: boolean;
    /**
     * Max TTL for the Consul token created from the role.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     */
    maxTtl?: string;
    /**
     * List of Node Identities to attach to the token. Available in Consul 1.8.1 or above.
     * @type {Array<string>}
     * @memberof ConsulWriteRoleRequest
     */
    nodeIdentities?: Array<string>;
    /**
     * Indicates which admin partition that the token will be created within. Defaults to 'default'. Available in Consul 1.11 and above.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     */
    partition?: string;
    /**
     * Use "consul_policies" instead.
     * @type {Array<string>}
     * @memberof ConsulWriteRoleRequest
     * @deprecated
     */
    policies?: Array<string>;
    /**
     * Policy document, base64 encoded. Required for 'client' tokens. Required for Consul pre-1.4.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     * @deprecated
     */
    policy?: string;
    /**
     * List of Service Identities to attach to the token, separated by semicolons. Available in Consul 1.5 or above.
     * @type {Array<string>}
     * @memberof ConsulWriteRoleRequest
     */
    serviceIdentities?: Array<string>;
    /**
     * Which type of token to create: 'client' or 'management'. If a 'management' token, the "policy", "policies", and "consul_roles" parameters are not required. Defaults to 'client'.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     * @deprecated
     */
    tokenType?: string;
    /**
     * TTL for the Consul token created from the role.
     * @type {string}
     * @memberof ConsulWriteRoleRequest
     */
    ttl?: string;
}
/**
 * Check if a given object implements the ConsulWriteRoleRequest interface.
 */
export declare function instanceOfConsulWriteRoleRequest(value: object): value is ConsulWriteRoleRequest;
export declare function ConsulWriteRoleRequestFromJSON(json: any): ConsulWriteRoleRequest;
export declare function ConsulWriteRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): ConsulWriteRoleRequest;
export declare function ConsulWriteRoleRequestToJSON(json: any): ConsulWriteRoleRequest;
export declare function ConsulWriteRoleRequestToJSONTyped(value?: ConsulWriteRoleRequest | null, ignoreDiscriminator?: boolean): any;
