/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AwsLoginRequest
 */
export interface AwsLoginRequest {
    /**
     * HTTP method to use for the AWS request when auth_type is iam. This must match what has been signed in the presigned request.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    iamHttpRequestMethod?: string;
    /**
     * Base64-encoded request body when auth_type is iam. This must match the request body included in the signature.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    iamRequestBody?: string;
    /**
     * Key/value pairs of headers for use in the sts:GetCallerIdentity HTTP requests headers when auth_type is iam. Can be either a Base64-encoded, JSON-serialized string, or a JSON object of key/value pairs. This must at a minimum include the headers over which AWS has included a signature.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    iamRequestHeaders?: string;
    /**
     * Base64-encoded full URL against which to make the AWS request when using iam auth_type.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    iamRequestUrl?: string;
    /**
     * Base64 encoded EC2 instance identity document. This needs to be supplied along with the 'signature' parameter. If using 'curl' for fetching the identity document, consider using the option '-w 0' while piping the output to 'base64' binary.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    identity?: string;
    /**
     * The nonce to be used for subsequent login requests when auth_type is ec2. If this parameter is not specified at all and if reauthentication is allowed, then the backend will generate a random nonce, attaches it to the instance's identity access list entry and returns the nonce back as part of auth metadata. This value should be used with further login requests, to establish client authenticity. Clients can choose to set a custom nonce if preferred, in which case, it is recommended that clients provide a strong nonce. If a nonce is provided but with an empty value, it indicates intent to disable reauthentication. Note that, when 'disallow_reauthentication' option is enabled on either the role or the role tag, the 'nonce' holds no significance.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    nonce?: string;
    /**
     * PKCS7 signature of the identity document when using an auth_type of ec2.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    pkcs7?: string;
    /**
     * Name of the role against which the login is being attempted. If 'role' is not specified, then the login endpoint looks for a role bearing the name of the AMI ID of the EC2 instance that is trying to login. If a matching role is not found, login fails.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    role?: string;
    /**
     * Base64 encoded SHA256 RSA signature of the instance identity document. This needs to be supplied along with 'identity' parameter.
     * @type {string}
     * @memberof AwsLoginRequest
     */
    signature?: string;
}
/**
 * Check if a given object implements the AwsLoginRequest interface.
 */
export declare function instanceOfAwsLoginRequest(value: object): value is AwsLoginRequest;
export declare function AwsLoginRequestFromJSON(json: any): AwsLoginRequest;
export declare function AwsLoginRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AwsLoginRequest;
export declare function AwsLoginRequestToJSON(json: any): AwsLoginRequest;
export declare function AwsLoginRequestToJSONTyped(value?: AwsLoginRequest | null, ignoreDiscriminator?: boolean): any;
