/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TransitConfigureKeyRequest
 */
export interface TransitConfigureKeyRequest {
    /**
     * Enables taking a backup of the named key in plaintext format. Once set, this cannot be disabled.
     * @type {boolean}
     * @memberof TransitConfigureKeyRequest
     */
    allowPlaintextBackup?: boolean;
    /**
     * Amount of time the key should live before being automatically rotated. A value of 0 disables automatic rotation for the key.
     * @type {string}
     * @memberof TransitConfigureKeyRequest
     */
    autoRotatePeriod?: string;
    /**
     * Whether to allow deletion of the key
     * @type {boolean}
     * @memberof TransitConfigureKeyRequest
     */
    deletionAllowed?: boolean;
    /**
     * Enables export of the key. Once set, this cannot be disabled.
     * @type {boolean}
     * @memberof TransitConfigureKeyRequest
     */
    exportable?: boolean;
    /**
     * If set, the minimum version of the key allowed to be decrypted. For signing keys, the minimum version allowed to be used for verification.
     * @type {number}
     * @memberof TransitConfigureKeyRequest
     */
    minDecryptionVersion?: number;
    /**
     * If set, the minimum version of the key allowed to be used for encryption; or for signing keys, to be used for signing. If set to zero, only the latest version of the key is allowed.
     * @type {number}
     * @memberof TransitConfigureKeyRequest
     */
    minEncryptionVersion?: number;
}
/**
 * Check if a given object implements the TransitConfigureKeyRequest interface.
 */
export declare function instanceOfTransitConfigureKeyRequest(value: object): value is TransitConfigureKeyRequest;
export declare function TransitConfigureKeyRequestFromJSON(json: any): TransitConfigureKeyRequest;
export declare function TransitConfigureKeyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitConfigureKeyRequest;
export declare function TransitConfigureKeyRequestToJSON(json: any): TransitConfigureKeyRequest;
export declare function TransitConfigureKeyRequestToJSONTyped(value?: TransitConfigureKeyRequest | null, ignoreDiscriminator?: boolean): any;
