/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TokenCreateOrphanRequest
 */
export interface TokenCreateOrphanRequest {
    /**
     * Name to associate with this token
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    displayName?: string;
    /**
     * Name of the entity alias to associate with this token
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    entityAlias?: string;
    /**
     * Explicit Max TTL of this token
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    explicitMaxTtl?: string;
    /**
     * Value for the token
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    id?: string;
    /**
     * Use 'ttl' instead
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     * @deprecated
     */
    lease?: string;
    /**
     * Arbitrary key=value metadata to associate with the token
     * @type {object}
     * @memberof TokenCreateOrphanRequest
     */
    meta?: object;
    /**
     * Do not include default policy for this token
     * @type {boolean}
     * @memberof TokenCreateOrphanRequest
     */
    noDefaultPolicy?: boolean;
    /**
     * Create the token with no parent
     * @type {boolean}
     * @memberof TokenCreateOrphanRequest
     */
    noParent?: boolean;
    /**
     * Max number of uses for this token
     * @type {number}
     * @memberof TokenCreateOrphanRequest
     */
    numUses?: number;
    /**
     * Renew period
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    period?: string;
    /**
     * List of policies for the token
     * @type {Array<string>}
     * @memberof TokenCreateOrphanRequest
     */
    policies?: Array<string>;
    /**
     * Allow token to be renewed past its initial TTL up to system/mount maximum TTL
     * @type {boolean}
     * @memberof TokenCreateOrphanRequest
     */
    renewable?: boolean;
    /**
     * Time to live for this token
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    ttl?: string;
    /**
     * Token type
     * @type {string}
     * @memberof TokenCreateOrphanRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the TokenCreateOrphanRequest interface.
 */
export declare function instanceOfTokenCreateOrphanRequest(value: object): value is TokenCreateOrphanRequest;
export declare function TokenCreateOrphanRequestFromJSON(json: any): TokenCreateOrphanRequest;
export declare function TokenCreateOrphanRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TokenCreateOrphanRequest;
export declare function TokenCreateOrphanRequestToJSON(json: any): TokenCreateOrphanRequest;
export declare function TokenCreateOrphanRequestToJSONTyped(value?: TokenCreateOrphanRequest | null, ignoreDiscriminator?: boolean): any;
