/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TokenCreateAgainstRoleRequest
 */
export interface TokenCreateAgainstRoleRequest {
    /**
     * Name to associate with this token
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    displayName?: string;
    /**
     * Name of the entity alias to associate with this token
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    entityAlias?: string;
    /**
     * Explicit Max TTL of this token
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    explicitMaxTtl?: string;
    /**
     * Value for the token
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    id?: string;
    /**
     * Use 'ttl' instead
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     * @deprecated
     */
    lease?: string;
    /**
     * Arbitrary key=value metadata to associate with the token
     * @type {object}
     * @memberof TokenCreateAgainstRoleRequest
     */
    meta?: object;
    /**
     * Do not include default policy for this token
     * @type {boolean}
     * @memberof TokenCreateAgainstRoleRequest
     */
    noDefaultPolicy?: boolean;
    /**
     * Create the token with no parent
     * @type {boolean}
     * @memberof TokenCreateAgainstRoleRequest
     */
    noParent?: boolean;
    /**
     * Max number of uses for this token
     * @type {number}
     * @memberof TokenCreateAgainstRoleRequest
     */
    numUses?: number;
    /**
     * Renew period
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    period?: string;
    /**
     * List of policies for the token
     * @type {Array<string>}
     * @memberof TokenCreateAgainstRoleRequest
     */
    policies?: Array<string>;
    /**
     * Allow token to be renewed past its initial TTL up to system/mount maximum TTL
     * @type {boolean}
     * @memberof TokenCreateAgainstRoleRequest
     */
    renewable?: boolean;
    /**
     * Time to live for this token
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    ttl?: string;
    /**
     * Token type
     * @type {string}
     * @memberof TokenCreateAgainstRoleRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the TokenCreateAgainstRoleRequest interface.
 */
export declare function instanceOfTokenCreateAgainstRoleRequest(value: object): value is TokenCreateAgainstRoleRequest;
export declare function TokenCreateAgainstRoleRequestFromJSON(json: any): TokenCreateAgainstRoleRequest;
export declare function TokenCreateAgainstRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TokenCreateAgainstRoleRequest;
export declare function TokenCreateAgainstRoleRequestToJSON(json: any): TokenCreateAgainstRoleRequest;
export declare function TokenCreateAgainstRoleRequestToJSONTyped(value?: TokenCreateAgainstRoleRequest | null, ignoreDiscriminator?: boolean): any;
