/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemPatchSyncDestinationsVercelProjectNameRequest
 */
export interface SystemPatchSyncDestinationsVercelProjectNameRequest {
    /**
     * Vercel API access token with the permissions to manage environment variables.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    accessToken?: string;
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * Deployment environments where the environment variables are available. Accepts 'development', 'preview' & 'production'.
     * @type {Array<string>}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    deploymentEnvironments?: Array<string>;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    granularity?: string;
    /**
     * Project ID where to manage environment variables.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    projectId?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    purge?: boolean;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    secretNameTemplate?: string;
    /**
     * Team ID the project belongs to. Optional.
     * @type {string}
     * @memberof SystemPatchSyncDestinationsVercelProjectNameRequest
     */
    teamId?: string;
}
/**
 * Check if a given object implements the SystemPatchSyncDestinationsVercelProjectNameRequest interface.
 */
export declare function instanceOfSystemPatchSyncDestinationsVercelProjectNameRequest(value: object): value is SystemPatchSyncDestinationsVercelProjectNameRequest;
export declare function SystemPatchSyncDestinationsVercelProjectNameRequestFromJSON(json: any): SystemPatchSyncDestinationsVercelProjectNameRequest;
export declare function SystemPatchSyncDestinationsVercelProjectNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemPatchSyncDestinationsVercelProjectNameRequest;
export declare function SystemPatchSyncDestinationsVercelProjectNameRequestToJSON(json: any): SystemPatchSyncDestinationsVercelProjectNameRequest;
export declare function SystemPatchSyncDestinationsVercelProjectNameRequestToJSONTyped(value?: SystemPatchSyncDestinationsVercelProjectNameRequest | null, ignoreDiscriminator?: boolean): any;
