/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface RekeyAttemptInitializeRequest
 */
export interface RekeyAttemptInitializeRequest {
    /**
     * Specifies if using PGP-encrypted keys, whether Vault should also store a plaintext backup of the PGP-encrypted keys.
     * @type {boolean}
     * @memberof RekeyAttemptInitializeRequest
     */
    backup?: boolean;
    /**
     * Specifies an array of PGP public keys used to encrypt the output unseal keys. Ordering is preserved. The keys must be base64-encoded from their original binary representation. The size of this array must be the same as secret_shares.
     * @type {Array<string>}
     * @memberof RekeyAttemptInitializeRequest
     */
    pgpKeys?: Array<string>;
    /**
     * Turns on verification functionality
     * @type {boolean}
     * @memberof RekeyAttemptInitializeRequest
     */
    requireVerification?: boolean;
    /**
     * Specifies the number of shares to split the unseal key into.
     * @type {number}
     * @memberof RekeyAttemptInitializeRequest
     */
    secretShares?: number;
    /**
     * Specifies the number of shares required to reconstruct the unseal key. This must be less than or equal secret_shares. If using Vault HSM with auto-unsealing, this value must be the same as secret_shares.
     * @type {number}
     * @memberof RekeyAttemptInitializeRequest
     */
    secretThreshold?: number;
}
/**
 * Check if a given object implements the RekeyAttemptInitializeRequest interface.
 */
export declare function instanceOfRekeyAttemptInitializeRequest(value: object): value is RekeyAttemptInitializeRequest;
export declare function RekeyAttemptInitializeRequestFromJSON(json: any): RekeyAttemptInitializeRequest;
export declare function RekeyAttemptInitializeRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): RekeyAttemptInitializeRequest;
export declare function RekeyAttemptInitializeRequestToJSON(json: any): RekeyAttemptInitializeRequest;
export declare function RekeyAttemptInitializeRequestToJSONTyped(value?: RekeyAttemptInitializeRequest | null, ignoreDiscriminator?: boolean): any;
