/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiRevokeIssuerResponse
 */
export interface PkiRevokeIssuerResponse {
    /**
     * CA Chain
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    caChain?: Array<string>;
    /**
     * Certificate
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    certificate?: string;
    /**
     * CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Delta CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether critical extension checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    disableCriticalExtensionChecks?: boolean;
    /**
     * Whether the issuer name check should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    disableNameChecks?: boolean;
    /**
     * Whether name contraint checks shoul be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    disableNameConstraintChecks?: boolean;
    /**
     * Whether max path length checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    disablePathLengthChecks?: boolean;
    /**
     * Whether or not templating is enabled for AIA fields
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    enableAiaUrlTemplating?: boolean;
    /**
     * Issuer Id
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    issuerId?: string;
    /**
     * Issuer Name
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    issuerName?: string;
    /**
     * Issuing Certificates
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    issuingCertificates?: Array<string>;
    /**
     * Key Id
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    keyId?: string;
    /**
     * Leaf Not After Behavior
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    leafNotAfterBehavior?: string;
    /**
     * Manual Chain
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    manualChain?: Array<string>;
    /**
     * OCSP Servers
     * @type {Array<string>}
     * @memberof PkiRevokeIssuerResponse
     */
    ocspServers?: Array<string>;
    /**
     * Revocation Signature Alogrithm
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    revocationSignatureAlgorithm?: string;
    /**
     * Revocation time
     * @type {number}
     * @memberof PkiRevokeIssuerResponse
     */
    revocationTime?: number;
    /**
     * Revocation time RFC 3339 formatted
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    revocationTimeRfc3339?: string;
    /**
     * Revoked
     * @type {boolean}
     * @memberof PkiRevokeIssuerResponse
     */
    revoked?: boolean;
    /**
     * Usage
     * @type {string}
     * @memberof PkiRevokeIssuerResponse
     */
    usage?: string;
}
/**
 * Check if a given object implements the PkiRevokeIssuerResponse interface.
 */
export declare function instanceOfPkiRevokeIssuerResponse(value: object): value is PkiRevokeIssuerResponse;
export declare function PkiRevokeIssuerResponseFromJSON(json: any): PkiRevokeIssuerResponse;
export declare function PkiRevokeIssuerResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiRevokeIssuerResponse;
export declare function PkiRevokeIssuerResponseToJSON(json: any): PkiRevokeIssuerResponse;
export declare function PkiRevokeIssuerResponseToJSONTyped(value?: PkiRevokeIssuerResponse | null, ignoreDiscriminator?: boolean): any;
