/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiPatchIssuerResponse
 */
export interface PkiPatchIssuerResponse {
    /**
     * CA Chain
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    caChain?: Array<string>;
    /**
     * Certificate
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    certificate?: string;
    /**
     * CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Delta CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether critical extension checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    disableCriticalExtensionChecks?: boolean;
    /**
     * Whether the issuer name check should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    disableNameChecks?: boolean;
    /**
     * Whether name contraint checks shoul be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    disableNameConstraintChecks?: boolean;
    /**
     * Whether max path length checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    disablePathLengthChecks?: boolean;
    /**
     * Whether or not templating is enabled for AIA fields
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    enableAiaUrlTemplating?: boolean;
    /**
     * Issuer Id
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    issuerId?: string;
    /**
     * Issuer Name
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    issuerName?: string;
    /**
     * Issuing Certificates
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    issuingCertificates?: Array<string>;
    /**
     * Key Id
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    keyId?: string;
    /**
     * Leaf Not After Behavior
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    leafNotAfterBehavior?: string;
    /**
     * Manual Chain
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    manualChain?: Array<string>;
    /**
     * OCSP Servers
     * @type {Array<string>}
     * @memberof PkiPatchIssuerResponse
     */
    ocspServers?: Array<string>;
    /**
     * Revocation Signature Alogrithm
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    revocationSignatureAlgorithm?: string;
    /**
     * Revocation time
     * @type {number}
     * @memberof PkiPatchIssuerResponse
     */
    revocationTime?: number;
    /**
     * Revocation time RFC 3339 formatted
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    revocationTimeRfc3339?: string;
    /**
     * Revoked
     * @type {boolean}
     * @memberof PkiPatchIssuerResponse
     */
    revoked?: boolean;
    /**
     * Usage
     * @type {string}
     * @memberof PkiPatchIssuerResponse
     */
    usage?: string;
}
/**
 * Check if a given object implements the PkiPatchIssuerResponse interface.
 */
export declare function instanceOfPkiPatchIssuerResponse(value: object): value is PkiPatchIssuerResponse;
export declare function PkiPatchIssuerResponseFromJSON(json: any): PkiPatchIssuerResponse;
export declare function PkiPatchIssuerResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiPatchIssuerResponse;
export declare function PkiPatchIssuerResponseToJSON(json: any): PkiPatchIssuerResponse;
export declare function PkiPatchIssuerResponseToJSONTyped(value?: PkiPatchIssuerResponse | null, ignoreDiscriminator?: boolean): any;
