/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiConfigureEstRequest
 */
export interface PkiConfigureEstRequest {
    /**
     * Fields parsed from the CSR that appear in the audit and can be used by sentinel policies. Options are: [csr common_name alt_names ip_sans uri_sans other_sans signature_bits exclude_cn_from_sans ou organization country locality province street_address postal_code serial_number use_pss key_type key_bits add_basic_constraints]
     * @type {Array<string>}
     * @memberof PkiConfigureEstRequest
     */
    auditFields?: Array<string>;
    /**
     * A map of authentication type to authentication parameters
     * @type {object}
     * @memberof PkiConfigureEstRequest
     */
    authenticators?: object;
    /**
     * Indicates if this mount owns the .well-known/est mount path
     * @type {boolean}
     * @memberof PkiConfigureEstRequest
     */
    defaultMount?: boolean;
    /**
     * the policy of the default EST responder path, required if default_mount is true
     * @type {string}
     * @memberof PkiConfigureEstRequest
     */
    defaultPathPolicy?: string;
    /**
     * Parse CSR to that its fields can be used by sentinel policies.
     * @type {boolean}
     * @memberof PkiConfigureEstRequest
     */
    enableSentinelParsing?: boolean;
    /**
     * whether EST is enabled, defaults to false
     * @type {boolean}
     * @memberof PkiConfigureEstRequest
     */
    enabled?: boolean;
    /**
     * The EST label to register and its associated role path
     * @type {object}
     * @memberof PkiConfigureEstRequest
     */
    labelToPathPolicy?: object;
}
/**
 * Check if a given object implements the PkiConfigureEstRequest interface.
 */
export declare function instanceOfPkiConfigureEstRequest(value: object): value is PkiConfigureEstRequest;
export declare function PkiConfigureEstRequestFromJSON(json: any): PkiConfigureEstRequest;
export declare function PkiConfigureEstRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiConfigureEstRequest;
export declare function PkiConfigureEstRequestToJSON(json: any): PkiConfigureEstRequest;
export declare function PkiConfigureEstRequestToJSONTyped(value?: PkiConfigureEstRequest | null, ignoreDiscriminator?: boolean): any;
