/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiConfigureAutoTidyRequest
 */
export interface PkiConfigureAutoTidyRequest {
    /**
     * The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    acmeAccountSafetyBuffer?: string;
    /**
     * Set to true to enable automatic tidy operations.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    enabled?: boolean;
    /**
     * Interval at which to run an auto-tidy operation. This is the time between tidy invocations (after one finishes to the start of the next). Running a manual tidy will reset this duration.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    intervalDuration?: string;
    /**
     * The amount of extra time that must have passed beyond issuer's expiration before it is removed from the backend storage. Defaults to 8760 hours (1 year).
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    issuerSafetyBuffer?: string;
    /**
     * This configures whether stored certificates are counted upon initialization of the backend, and whether during normal operation, a running count of certificates stored is maintained.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    maintainStoredCertificateCounts?: boolean;
    /**
     * The maximum amount of time in seconds auto-tidy will be delayed after startup.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    maxStartupBackoffDuration?: string;
    /**
     * The minimum amount of time in seconds auto-tidy will be delayed after startup.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    minStartupBackoffDuration?: string;
    /**
     * The amount of time to wait between processing certificates. This allows operators to change the execution profile of tidy to take consume less resources by slowing down how long it takes to run. Note that the entire list of certificates will be stored in memory during the entire tidy operation, but resources to read/process/update existing entries will be spread out over a greater period of time. By default this is zero seconds.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    pauseDuration?: string;
    /**
     * This configures whether the stored certificate count is published to the metrics consumer. It does not affect if the stored certificate count is maintained, and if maintained, it will be available on the tidy-status endpoint.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    publishStoredCertificateCountMetrics?: boolean;
    /**
     * The amount of time that must pass from the cross-cluster revocation request being initiated to when it will be slated for removal. Setting this too low may remove valid revocation requests before the owning cluster has a chance to process them, especially if the cluster is offline.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    revocationQueueSafetyBuffer?: string;
    /**
     * The amount of extra time that must have passed beyond certificate expiration before it is removed from the backend storage and/or revocation list. Defaults to 72 hours.
     * @type {string}
     * @memberof PkiConfigureAutoTidyRequest
     */
    safetyBuffer?: string;
    /**
     * Set to true to enable tidying ACME accounts, orders and authorizations. ACME orders are tidied (deleted) safety_buffer after the certificate associated with them expires, or after the order and relevant authorizations have expired if no certificate was produced. Authorizations are tidied with the corresponding order. When a valid ACME Account is at least acme_account_safety_buffer old, and has no remaining orders associated with it, the account is marked as revoked. After another acme_account_safety_buffer has passed from the revocation or deactivation date, a revoked or deactivated ACME account is deleted.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyAcme?: boolean;
    /**
     * Set to true to enable tidying up certificate metadata
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyCertMetadata?: boolean;
    /**
     * Set to true to enable tidying up the certificate store
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyCertStore?: boolean;
    /**
     * Set to true to enable tidying up the CMPv2 nonce store
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyCmpv2NonceStore?: boolean;
    /**
     * Set to true to enable tidying up the cross-cluster revoked certificate store. Only runs on the active primary node.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyCrossClusterRevokedCerts?: boolean;
    /**
     * Set to true to automatically remove expired issuers past the issuer_safety_buffer. No keys will be removed as part of this operation.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyExpiredIssuers?: boolean;
    /**
     * Set to true to move the legacy ca_bundle from /config/ca_bundle to /config/ca_bundle.bak. This prevents downgrades to pre-Vault 1.11 versions (as older PKI engines do not know about the new multi-issuer storage layout), but improves the performance on seal wrapped PKI mounts. This will only occur if at least issuer_safety_buffer time has occurred after the initial storage migration. This backup is saved in case of an issue in future migrations. Operators may consider removing it via sys/raw if they desire. The backup will be removed via a DELETE /root call, but note that this removes ALL issuers within the mount (and is thus not desirable in most operational scenarios).
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyMoveLegacyCaBundle?: boolean;
    /**
     * Deprecated; synonym for 'tidy_revoked_certs
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyRevocationList?: boolean;
    /**
     * Set to true to remove stale revocation queue entries that haven't been confirmed by any active cluster. Only runs on the active primary node
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyRevocationQueue?: boolean;
    /**
     * Set to true to validate issuer associations on revocation entries. This helps increase the performance of CRL building and OCSP responses.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyRevokedCertIssuerAssociations?: boolean;
    /**
     * Set to true to expire all revoked and expired certificates, removing them both from the CRL and from storage. The CRL will be rotated if this causes any values to be removed.
     * @type {boolean}
     * @memberof PkiConfigureAutoTidyRequest
     */
    tidyRevokedCerts?: boolean;
}
/**
 * Check if a given object implements the PkiConfigureAutoTidyRequest interface.
 */
export declare function instanceOfPkiConfigureAutoTidyRequest(value: object): value is PkiConfigureAutoTidyRequest;
export declare function PkiConfigureAutoTidyRequestFromJSON(json: any): PkiConfigureAutoTidyRequest;
export declare function PkiConfigureAutoTidyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiConfigureAutoTidyRequest;
export declare function PkiConfigureAutoTidyRequestToJSON(json: any): PkiConfigureAutoTidyRequest;
export declare function PkiConfigureAutoTidyRequestToJSONTyped(value?: PkiConfigureAutoTidyRequest | null, ignoreDiscriminator?: boolean): any;
