/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface OidcWriteClientRequest
 */
export interface OidcWriteClientRequest {
    /**
     * The time-to-live for access tokens obtained by the client.
     * @type {string}
     * @memberof OidcWriteClientRequest
     */
    accessTokenTtl?: string;
    /**
     * Comma separated string or array of assignment resources.
     * @type {Array<string>}
     * @memberof OidcWriteClientRequest
     */
    assignments?: Array<string>;
    /**
     * The client type based on its ability to maintain confidentiality of credentials. The following client types are supported: 'confidential', 'public'. Defaults to 'confidential'.
     * @type {string}
     * @memberof OidcWriteClientRequest
     */
    clientType?: string;
    /**
     * The time-to-live for ID tokens obtained by the client.
     * @type {string}
     * @memberof OidcWriteClientRequest
     */
    idTokenTtl?: string;
    /**
     * A reference to a named key resource. Cannot be modified after creation. Defaults to the 'default' key.
     * @type {string}
     * @memberof OidcWriteClientRequest
     */
    key?: string;
    /**
     * Comma separated string or array of redirect URIs used by the client. One of these values must exactly match the redirect_uri parameter value used in each authentication request.
     * @type {Array<string>}
     * @memberof OidcWriteClientRequest
     */
    redirectUris?: Array<string>;
}
/**
 * Check if a given object implements the OidcWriteClientRequest interface.
 */
export declare function instanceOfOidcWriteClientRequest(value: object): value is OidcWriteClientRequest;
export declare function OidcWriteClientRequestFromJSON(json: any): OidcWriteClientRequest;
export declare function OidcWriteClientRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): OidcWriteClientRequest;
export declare function OidcWriteClientRequestToJSON(json: any): OidcWriteClientRequest;
export declare function OidcWriteClientRequestToJSONTyped(value?: OidcWriteClientRequest | null, ignoreDiscriminator?: boolean): any;
