/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface MfaUpdateTotpMethodRequest
 */
export interface MfaUpdateTotpMethodRequest {
    /**
     * The hashing algorithm used to generate the TOTP token. Options include SHA1, SHA256 and SHA512.
     * @type {string}
     * @memberof MfaUpdateTotpMethodRequest
     */
    algorithm?: string;
    /**
     * The number of digits in the generated TOTP token. This value can either be 6 or 8.
     * @type {number}
     * @memberof MfaUpdateTotpMethodRequest
     */
    digits?: number;
    /**
     * The name of the key's issuing organization.
     * @type {string}
     * @memberof MfaUpdateTotpMethodRequest
     */
    issuer?: string;
    /**
     * Determines the size in bytes of the generated key.
     * @type {number}
     * @memberof MfaUpdateTotpMethodRequest
     */
    keySize?: number;
    /**
     * Max number of allowed validation attempts.
     * @type {number}
     * @memberof MfaUpdateTotpMethodRequest
     */
    maxValidationAttempts?: number;
    /**
     * The unique name identifier for this MFA method.
     * @type {string}
     * @memberof MfaUpdateTotpMethodRequest
     */
    methodName?: string;
    /**
     * The length of time used to generate a counter for the TOTP token calculation.
     * @type {string}
     * @memberof MfaUpdateTotpMethodRequest
     */
    period?: string;
    /**
     * The pixel size of the generated square QR code.
     * @type {number}
     * @memberof MfaUpdateTotpMethodRequest
     */
    qrSize?: number;
    /**
     * The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1.
     * @type {number}
     * @memberof MfaUpdateTotpMethodRequest
     */
    skew?: number;
}
/**
 * Check if a given object implements the MfaUpdateTotpMethodRequest interface.
 */
export declare function instanceOfMfaUpdateTotpMethodRequest(value: object): value is MfaUpdateTotpMethodRequest;
export declare function MfaUpdateTotpMethodRequestFromJSON(json: any): MfaUpdateTotpMethodRequest;
export declare function MfaUpdateTotpMethodRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): MfaUpdateTotpMethodRequest;
export declare function MfaUpdateTotpMethodRequestToJSON(json: any): MfaUpdateTotpMethodRequest;
export declare function MfaUpdateTotpMethodRequestToJSONTyped(value?: MfaUpdateTotpMethodRequest | null, ignoreDiscriminator?: boolean): any;
