/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface MfaCreateTotpMethodRequest
 */
export interface MfaCreateTotpMethodRequest {
    /**
     * The hashing algorithm used to generate the TOTP token. Options include SHA1, SHA256 and SHA512.
     * @type {string}
     * @memberof MfaCreateTotpMethodRequest
     */
    algorithm?: string;
    /**
     * The number of digits in the generated TOTP token. This value can either be 6 or 8.
     * @type {number}
     * @memberof MfaCreateTotpMethodRequest
     */
    digits?: number;
    /**
     * The name of the key's issuing organization.
     * @type {string}
     * @memberof MfaCreateTotpMethodRequest
     */
    issuer?: string;
    /**
     * Determines the size in bytes of the generated key.
     * @type {number}
     * @memberof MfaCreateTotpMethodRequest
     */
    keySize?: number;
    /**
     * Max number of allowed validation attempts.
     * @type {number}
     * @memberof MfaCreateTotpMethodRequest
     */
    maxValidationAttempts?: number;
    /**
     * The unique name identifier for this MFA method.
     * @type {string}
     * @memberof MfaCreateTotpMethodRequest
     */
    methodName?: string;
    /**
     * The length of time used to generate a counter for the TOTP token calculation.
     * @type {string}
     * @memberof MfaCreateTotpMethodRequest
     */
    period?: string;
    /**
     * The pixel size of the generated square QR code.
     * @type {number}
     * @memberof MfaCreateTotpMethodRequest
     */
    qrSize?: number;
    /**
     * The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1.
     * @type {number}
     * @memberof MfaCreateTotpMethodRequest
     */
    skew?: number;
}
/**
 * Check if a given object implements the MfaCreateTotpMethodRequest interface.
 */
export declare function instanceOfMfaCreateTotpMethodRequest(value: object): value is MfaCreateTotpMethodRequest;
export declare function MfaCreateTotpMethodRequestFromJSON(json: any): MfaCreateTotpMethodRequest;
export declare function MfaCreateTotpMethodRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): MfaCreateTotpMethodRequest;
export declare function MfaCreateTotpMethodRequestToJSON(json: any): MfaCreateTotpMethodRequest;
export declare function MfaCreateTotpMethodRequestToJSONTyped(value?: MfaCreateTotpMethodRequest | null, ignoreDiscriminator?: boolean): any;
