/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface KubernetesWriteRoleRequest
 */
export interface KubernetesWriteRoleRequest {
    /**
     * A label selector for Kubernetes namespaces in which credentials can be generated. Accepts either a JSON or YAML object. If set with allowed_kubernetes_namespaces, the conditions are conjuncted.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    allowedKubernetesNamespaceSelector?: string;
    /**
     * A list of the Kubernetes namespaces in which credentials can be generated. If set to "*" all namespaces are allowed.
     * @type {Array<string>}
     * @memberof KubernetesWriteRoleRequest
     */
    allowedKubernetesNamespaces?: Array<string>;
    /**
     * Additional annotations to apply to all generated Kubernetes objects.
     * @type {object}
     * @memberof KubernetesWriteRoleRequest
     */
    extraAnnotations?: object;
    /**
     * Additional labels to apply to all generated Kubernetes objects.
     * @type {object}
     * @memberof KubernetesWriteRoleRequest
     */
    extraLabels?: object;
    /**
     * The Role or ClusterRole rules to use when generating a role. Accepts either a JSON or YAML object. If set, the entire chain of Kubernetes objects will be generated.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    generatedRoleRules?: string;
    /**
     * The pre-existing Role or ClusterRole to bind a generated service account to. If set, Kubernetes token, service account, and role binding objects will be created.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    kubernetesRoleName?: string;
    /**
     * Specifies whether the Kubernetes role is a Role or ClusterRole.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    kubernetesRoleType?: string;
    /**
     * The name template to use when generating service accounts, roles and role bindings. If unset, a default template is used.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    nameTemplate?: string;
    /**
     * The pre-existing service account to generate tokens for. Mutually exclusive with all role parameters. If set, only a Kubernetes service account token will be created.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    serviceAccountName?: string;
    /**
     * The default audiences for generated Kubernetes service account tokens. If not set or set to "", will use k8s cluster default.
     * @type {Array<string>}
     * @memberof KubernetesWriteRoleRequest
     */
    tokenDefaultAudiences?: Array<string>;
    /**
     * The default ttl for generated Kubernetes service account tokens. If not set or set to 0, will use system default.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    tokenDefaultTtl?: string;
    /**
     * The maximum ttl for generated Kubernetes service account tokens. If not set or set to 0, will use system default.
     * @type {string}
     * @memberof KubernetesWriteRoleRequest
     */
    tokenMaxTtl?: string;
}
/**
 * Check if a given object implements the KubernetesWriteRoleRequest interface.
 */
export declare function instanceOfKubernetesWriteRoleRequest(value: object): value is KubernetesWriteRoleRequest;
export declare function KubernetesWriteRoleRequestFromJSON(json: any): KubernetesWriteRoleRequest;
export declare function KubernetesWriteRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): KubernetesWriteRoleRequest;
export declare function KubernetesWriteRoleRequestToJSON(json: any): KubernetesWriteRoleRequest;
export declare function KubernetesWriteRoleRequestToJSONTyped(value?: KubernetesWriteRoleRequest | null, ignoreDiscriminator?: boolean): any;
