/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface KubernetesConfigureAuthRequest
 */
export interface KubernetesConfigureAuthRequest {
    /**
     * Disable JWT issuer validation (Deprecated, will be removed in a future release)
     * @type {boolean}
     * @memberof KubernetesConfigureAuthRequest
     * @deprecated
     */
    disableIssValidation?: boolean;
    /**
     * Disable defaulting to the local CA cert and service account JWT when running in a Kubernetes pod
     * @type {boolean}
     * @memberof KubernetesConfigureAuthRequest
     */
    disableLocalCaJwt?: boolean;
    /**
     * Optional JWT issuer. If no issuer is specified, then this plugin will use kubernetes.io/serviceaccount as the default issuer. (Deprecated, will be removed in a future release)
     * @type {string}
     * @memberof KubernetesConfigureAuthRequest
     * @deprecated
     */
    issuer?: string;
    /**
     * Optional PEM encoded CA cert for use by the TLS client used to talk with the API. If it is not set and disable_local_ca_jwt is true, the system's trusted CA certificate pool will be used.
     * @type {string}
     * @memberof KubernetesConfigureAuthRequest
     */
    kubernetesCaCert?: string;
    /**
     * Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server.
     * @type {string}
     * @memberof KubernetesConfigureAuthRequest
     */
    kubernetesHost?: string;
    /**
     * Optional list of PEM-formated public keys or certificates used to verify the signatures of kubernetes service account JWTs. If a certificate is given, its public key will be extracted. Not every installation of Kubernetes exposes these keys.
     * @type {Array<string>}
     * @memberof KubernetesConfigureAuthRequest
     */
    pemKeys?: Array<string>;
    /**
     * A service account JWT (or other token) used as a bearer token to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API.
     * @type {string}
     * @memberof KubernetesConfigureAuthRequest
     */
    tokenReviewerJwt?: string;
    /**
     * Use annotations from the client token's associated service account as alias metadata for the Vault entity. Only annotations with the prefix "vault.hashicorp.com/alias-metadata-" will be used. Note that Vault will need permission to read service accounts from the Kubernetes API.
     * @type {boolean}
     * @memberof KubernetesConfigureAuthRequest
     */
    useAnnotationsAsAliasMetadata?: boolean;
}
/**
 * Check if a given object implements the KubernetesConfigureAuthRequest interface.
 */
export declare function instanceOfKubernetesConfigureAuthRequest(value: object): value is KubernetesConfigureAuthRequest;
export declare function KubernetesConfigureAuthRequestFromJSON(json: any): KubernetesConfigureAuthRequest;
export declare function KubernetesConfigureAuthRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): KubernetesConfigureAuthRequest;
export declare function KubernetesConfigureAuthRequestToJSON(json: any): KubernetesConfigureAuthRequest;
export declare function KubernetesConfigureAuthRequestToJSONTyped(value?: KubernetesConfigureAuthRequest | null, ignoreDiscriminator?: boolean): any;
