/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface JwtConfigureRequest
 */
export interface JwtConfigureRequest {
    /**
     * The value against which to match the 'iss' claim in a JWT. Optional.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    boundIssuer?: string;
    /**
     * The default role to use if none is provided during login. If not set, a role is required during login.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    defaultRole?: string;
    /**
     * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    jwksCaPem?: string;
    /**
     * Set of JWKS Url and CA certificate (or chain of certificates) pairs. CA certificates must be in PEM format. Cannot be used with "jwks_url" or "jwks_ca_pem".
     * @type {Array<object>}
     * @memberof JwtConfigureRequest
     */
    jwksPairs?: Array<object>;
    /**
     * JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    jwksUrl?: string;
    /**
     * A list of supported signing algorithms. Defaults to RS256.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    jwtSupportedAlgs?: Array<string>;
    /**
     * A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used with "jwks_url" or "oidc_discovery_url".
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    jwtValidationPubkeys?: Array<string>;
    /**
     * Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs.
     * @type {boolean}
     * @memberof JwtConfigureRequest
     */
    namespaceInState?: boolean;
    /**
     * The OAuth Client ID configured with your OIDC provider.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcClientId?: string;
    /**
     * The OAuth Client Secret configured with your OIDC provider.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcClientSecret?: string;
    /**
     * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcDiscoveryCaPem?: string;
    /**
     * OIDC Discovery URL, without any .well-known component (base path). Cannot be used with "jwks_url" or "jwt_validation_pubkeys".
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcDiscoveryUrl?: string;
    /**
     * The response mode to be used in the OAuth2 request. Allowed values are 'query' and 'form_post'.
     * @type {string}
     * @memberof JwtConfigureRequest
     */
    oidcResponseMode?: string;
    /**
     * The response types to request. Allowed values are 'code' and 'id_token'. Defaults to 'code'.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    oidcResponseTypes?: Array<string>;
    /**
     * Provider-specific configuration. Optional.
     * @type {object}
     * @memberof JwtConfigureRequest
     */
    providerConfig?: object;
    /**
     * A list of ASN1 OIDs of certificate extensions marked Critical that are unsupported by Vault and should be ignored. This option should very rarely be needed except in specialized PKI environments.
     * @type {Array<string>}
     * @memberof JwtConfigureRequest
     */
    unsupportedCriticalCertExtensions?: Array<string>;
}
/**
 * Check if a given object implements the JwtConfigureRequest interface.
 */
export declare function instanceOfJwtConfigureRequest(value: object): value is JwtConfigureRequest;
export declare function JwtConfigureRequestFromJSON(json: any): JwtConfigureRequest;
export declare function JwtConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): JwtConfigureRequest;
export declare function JwtConfigureRequestToJSON(json: any): JwtConfigureRequest;
export declare function JwtConfigureRequestToJSONTyped(value?: JwtConfigureRequest | null, ignoreDiscriminator?: boolean): any;
