/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface GenerateUtilizationReportResponse
 */
export interface GenerateUtilizationReportResponse {
    /**
     * A map of auth methods, by type, to the number of mounts of that type across all namespaces.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    authMethods?: object;
    /**
     * Number of KVv1 secrets across all mounts and namespaces.
     * @type {number}
     * @memberof GenerateUtilizationReportResponse
     */
    kvv1Secrets?: number;
    /**
     * Number of KVv2 secrets across all mounts and namespaces.
     * @type {number}
     * @memberof GenerateUtilizationReportResponse
     */
    kvv2Secrets?: number;
    /**
     * A map containing details of lease count quotas, if in use, including total quotas and the status of the global lease count quota, if one is configured.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    leaseCountQuotas?: object;
    /**
     * A map of all auth methods, by type, to the number of active leases created by auth mounts of that type across all namespaces.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    leasesByAuthMethod?: object;
    /**
     * Number of namespaces.
     * @type {number}
     * @memberof GenerateUtilizationReportResponse
     */
    namespaces?: number;
    /**
     * A map containing 'total_roles' and 'total_issuers' for all PKI mounts across all namespaces, if PKI is in use.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    pki?: object;
    /**
     * A map containing details about replication status.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    replicationStatus?: object;
    /**
     * A map of secret engines, by type, to the number of mounts of that type across all namespaces.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    secretEngines?: object;
    /**
     * A map containing 'total_sources' and 'total_destinations' for secret syncs, if configured.
     * @type {object}
     * @memberof GenerateUtilizationReportResponse
     */
    secretSync?: object;
}
/**
 * Check if a given object implements the GenerateUtilizationReportResponse interface.
 */
export declare function instanceOfGenerateUtilizationReportResponse(value: object): value is GenerateUtilizationReportResponse;
export declare function GenerateUtilizationReportResponseFromJSON(json: any): GenerateUtilizationReportResponse;
export declare function GenerateUtilizationReportResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): GenerateUtilizationReportResponse;
export declare function GenerateUtilizationReportResponseToJSON(json: any): GenerateUtilizationReportResponse;
export declare function GenerateUtilizationReportResponseToJSONTyped(value?: GenerateUtilizationReportResponse | null, ignoreDiscriminator?: boolean): any;
