/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface DatabaseWriteStaticRoleRequest
 */
export interface DatabaseWriteStaticRoleRequest {
    /**
     * The configuration for the given credential_type.
     * @type {object}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    credentialConfig?: object;
    /**
     * The type of credential to manage. Options include: 'password', 'rsa_private_key'. Defaults to 'password'.
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    credentialType?: string;
    /**
     * Name of the database this role acts on.
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    dbName?: string;
    /**
     * Enterprise only. If set, the initial static account password of the external db user before the first Vault rotatation.
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    password?: string;
    /**
     * Period for automatic credential rotation of the given username. Not valid unless used with "username". Mutually exclusive with "rotation_schedule."
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    rotationPeriod?: string;
    /**
     * Schedule for automatic credential rotation of the given username. Mutually exclusive with "rotation_period."
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the database statements to be executed to rotate the accounts credentials. Not every plugin type will support this functionality. See the plugin's API page for more information on support and formatting for this parameter.
     * @type {Array<string>}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    rotationStatements?: Array<string>;
    /**
     * The window of time in which rotations are allowed to occur starting from a given "rotation_schedule". Requires "rotation_schedule" to be specified
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    rotationWindow?: string;
    /**
     * Used to connect to a self-managed static account. Must be provided by the user when root credentials are not provided.
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     * @deprecated
     */
    selfManagedPassword?: string;
    /**
     * Enterprise only. If true, the static account password will not be rotated on creation of the role. Defaults to false.
     * @type {boolean}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    skipImportRotation?: boolean;
    /**
     * Name of the static user account for Vault to manage. Requires "rotation_period" to be specified
     * @type {string}
     * @memberof DatabaseWriteStaticRoleRequest
     */
    username?: string;
}
/**
 * Check if a given object implements the DatabaseWriteStaticRoleRequest interface.
 */
export declare function instanceOfDatabaseWriteStaticRoleRequest(value: object): value is DatabaseWriteStaticRoleRequest;
export declare function DatabaseWriteStaticRoleRequestFromJSON(json: any): DatabaseWriteStaticRoleRequest;
export declare function DatabaseWriteStaticRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): DatabaseWriteStaticRoleRequest;
export declare function DatabaseWriteStaticRoleRequestToJSON(json: any): DatabaseWriteStaticRoleRequest;
export declare function DatabaseWriteStaticRoleRequestToJSONTyped(value?: DatabaseWriteStaticRoleRequest | null, ignoreDiscriminator?: boolean): any;
