/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface DatabaseConfigureConnectionRequest
 */
export interface DatabaseConfigureConnectionRequest {
    /**
     * Comma separated string or array of the role names allowed to get creds from this database connection. If empty no roles are allowed. If "*" all roles are allowed.
     * @type {Array<string>}
     * @memberof DatabaseConfigureConnectionRequest
     */
    allowedRoles?: Array<string>;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof DatabaseConfigureConnectionRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * Password policy to use when generating passwords.
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    passwordPolicy?: string;
    /**
     * The name of a builtin or previously registered plugin known to vault. This endpoint will create an instance of that plugin type.
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    pluginName?: string;
    /**
     * The version of the plugin to use.
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    pluginVersion?: string;
    /**
     * Specifies the database statements to be executed to rotate the root user's credentials. See the plugin's API page for more information on support and formatting for this parameter.
     * @type {Array<string>}
     * @memberof DatabaseConfigureConnectionRequest
     */
    rootRotationStatements?: Array<string>;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof DatabaseConfigureConnectionRequest
     */
    rotationWindow?: string;
    /**
     * Enterprise only. If true, the static roles associated with this connection will not have their passwords rotated on creation of the role. Defaults to false.
     * @type {boolean}
     * @memberof DatabaseConfigureConnectionRequest
     */
    skipStaticRoleImportRotation?: boolean;
    /**
     * If true, the connection details are verified by actually connecting to the database. Defaults to true.
     * @type {boolean}
     * @memberof DatabaseConfigureConnectionRequest
     */
    verifyConnection?: boolean;
}
/**
 * Check if a given object implements the DatabaseConfigureConnectionRequest interface.
 */
export declare function instanceOfDatabaseConfigureConnectionRequest(value: object): value is DatabaseConfigureConnectionRequest;
export declare function DatabaseConfigureConnectionRequestFromJSON(json: any): DatabaseConfigureConnectionRequest;
export declare function DatabaseConfigureConnectionRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): DatabaseConfigureConnectionRequest;
export declare function DatabaseConfigureConnectionRequestToJSON(json: any): DatabaseConfigureConnectionRequest;
export declare function DatabaseConfigureConnectionRequestToJSONTyped(value?: DatabaseConfigureConnectionRequest | null, ignoreDiscriminator?: boolean): any;
