/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AzureConfigureAuthRequest
 */
export interface AzureConfigureAuthRequest {
    /**
     * The OAuth2 client id to connection to Azure. This value can also be provided with the AZURE_CLIENT_ID environment variable.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    clientId?: string;
    /**
     * The OAuth2 client secret to connection to Azure. This value can also be provided with the AZURE_CLIENT_SECRET environment variable.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    clientSecret?: string;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof AzureConfigureAuthRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * The Azure environment name. If not provided, AzurePublicCloud is used. This value can also be provided with the AZURE_ENVIRONMENT environment variable.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    environment?: string;
    /**
     * Audience of plugin identity tokens
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    identityTokenAudience?: string;
    /**
     * Time-to-live of plugin identity tokens
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    identityTokenTtl?: string;
    /**
     * The maximum number of attempts a failed operation will be retried before producing an error.
     * @type {number}
     * @memberof AzureConfigureAuthRequest
     */
    maxRetries?: number;
    /**
     * The maximum delay allowed before retrying an operation.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    maxRetryDelay?: string;
    /**
     * The resource URL for the vault application in Azure Active Directory. This value can also be provided with the AZURE_AD_RESOURCE environment variable.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    resource?: string;
    /**
     * The initial amount of delay to use before retrying an operation, increasing exponentially.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    retryDelay?: string;
    /**
     * The TTL of the root password in Azure. This can be either a number of seconds or a time formatted duration (ex: 24h, 48ds)
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    rootPasswordTtl?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    rotationWindow?: string;
    /**
     * The tenant id for the Azure Active Directory. This is sometimes referred to as Directory ID in AD. This value can also be provided with the AZURE_TENANT_ID environment variable.
     * @type {string}
     * @memberof AzureConfigureAuthRequest
     */
    tenantId?: string;
}
/**
 * Check if a given object implements the AzureConfigureAuthRequest interface.
 */
export declare function instanceOfAzureConfigureAuthRequest(value: object): value is AzureConfigureAuthRequest;
export declare function AzureConfigureAuthRequestFromJSON(json: any): AzureConfigureAuthRequest;
export declare function AzureConfigureAuthRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AzureConfigureAuthRequest;
export declare function AzureConfigureAuthRequestToJSON(json: any): AzureConfigureAuthRequest;
export declare function AzureConfigureAuthRequestToJSONTyped(value?: AzureConfigureAuthRequest | null, ignoreDiscriminator?: boolean): any;
