/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AppRoleWriteSecretIdRequest
 */
export interface AppRoleWriteSecretIdRequest {
    /**
     * Comma separated string or list of CIDR blocks enforcing secret IDs to be used from specific set of IP addresses. If 'bound_cidr_list' is set on the role, then the list of CIDR blocks listed here should be a subset of the CIDR blocks listed on the role.
     * @type {Array<string>}
     * @memberof AppRoleWriteSecretIdRequest
     */
    cidrList?: Array<string>;
    /**
     * Metadata to be tied to the SecretID. This should be a JSON formatted string containing the metadata in key value pairs.
     * @type {string}
     * @memberof AppRoleWriteSecretIdRequest
     */
    metadata?: string;
    /**
     * Number of times this SecretID can be used, after which the SecretID expires. Overrides secret_id_num_uses role option when supplied. May not be higher than role's secret_id_num_uses.
     * @type {number}
     * @memberof AppRoleWriteSecretIdRequest
     */
    numUses?: number;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof AppRoleWriteSecretIdRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * Duration in seconds after which this SecretID expires. Overrides secret_id_ttl role option when supplied. May not be longer than role's secret_id_ttl.
     * @type {string}
     * @memberof AppRoleWriteSecretIdRequest
     */
    ttl?: string;
}
/**
 * Check if a given object implements the AppRoleWriteSecretIdRequest interface.
 */
export declare function instanceOfAppRoleWriteSecretIdRequest(value: object): value is AppRoleWriteSecretIdRequest;
export declare function AppRoleWriteSecretIdRequestFromJSON(json: any): AppRoleWriteSecretIdRequest;
export declare function AppRoleWriteSecretIdRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AppRoleWriteSecretIdRequest;
export declare function AppRoleWriteSecretIdRequestToJSON(json: any): AppRoleWriteSecretIdRequest;
export declare function AppRoleWriteSecretIdRequestToJSONTyped(value?: AppRoleWriteSecretIdRequest | null, ignoreDiscriminator?: boolean): any;
