/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime';
import type { AliasCreateRequest, AliasUpdateByIdRequest, EntitiesCreateDuplicatesRequest, EntityAliasCreateDuplicatesRequest, EntityAliasesCreateDuplicatesRequest, EntityBatchDeleteRequest, EntityCreateAliasRequest, EntityCreateRequest, EntityLookUpRequest, EntityMergeRequest, EntityUpdateAliasByIdRequest, EntityUpdateByIdRequest, EntityUpdateByNameRequest, GroupCreateAliasRequest, GroupCreateRequest, GroupLookUpRequest, GroupUpdateAliasByIdRequest, GroupUpdateByIdRequest, GroupUpdateByNameRequest, GroupsCreateDuplicatesRequest, MfaAdminDestroyTotpSecretRequest, MfaAdminGenerateTotpSecretRequest, MfaCreateDuoMethodRequest, MfaCreateOktaMethodRequest, MfaCreatePingIdMethodRequest, MfaCreateTotpMethodRequest, MfaGenerateTotpSecretRequest, MfaUpdateDuoMethodRequest, MfaUpdateOktaMethodRequest, MfaUpdatePingIdMethodRequest, MfaUpdateTotpMethodRequest, MfaWriteLoginEnforcementRequest, OidcConfigureRequest, OidcIntrospectRequest, OidcProviderAuthorizeWithParametersRequest, OidcProviderTokenRequest, OidcRotateKeyRequest, OidcWriteAssignmentRequest, OidcWriteClientRequest, OidcWriteKeyRequest, OidcWriteProviderRequest, OidcWriteRoleRequest, OidcWriteScopeRequest, PersonaCreateRequest, PersonaUpdateByIdRequest, StandardListResponse } from '../models/index';
export interface IdentityApiAliasCreateOperationRequest {
    aliasCreateRequest: AliasCreateRequest;
}
export interface IdentityApiAliasDeleteByIdRequest {
    id: string;
}
export interface IdentityApiAliasListByIdRequest {
    list: AliasListByIdListEnum;
}
export interface IdentityApiAliasReadByIdRequest {
    id: string;
}
export interface IdentityApiAliasUpdateByIdOperationRequest {
    id: string;
    aliasUpdateByIdRequest: AliasUpdateByIdRequest;
}
export interface IdentityApiEntitiesCreateDuplicatesOperationRequest {
    entitiesCreateDuplicatesRequest: EntitiesCreateDuplicatesRequest;
}
export interface IdentityApiEntityAliasCreateDuplicatesOperationRequest {
    entityAliasCreateDuplicatesRequest: EntityAliasCreateDuplicatesRequest;
}
export interface IdentityApiEntityAliasesCreateDuplicatesOperationRequest {
    entityAliasesCreateDuplicatesRequest: EntityAliasesCreateDuplicatesRequest;
}
export interface IdentityApiEntityBatchDeleteOperationRequest {
    entityBatchDeleteRequest: EntityBatchDeleteRequest;
}
export interface IdentityApiEntityCreateOperationRequest {
    entityCreateRequest: EntityCreateRequest;
}
export interface IdentityApiEntityCreateAliasOperationRequest {
    entityCreateAliasRequest: EntityCreateAliasRequest;
}
export interface IdentityApiEntityDeleteAliasByIdRequest {
    id: string;
}
export interface IdentityApiEntityDeleteByIdRequest {
    id: string;
}
export interface IdentityApiEntityDeleteByNameRequest {
    name: string;
}
export interface IdentityApiEntityListAliasesByIdRequest {
    list: EntityListAliasesByIdListEnum;
}
export interface IdentityApiEntityListByIdRequest {
    list: EntityListByIdListEnum;
}
export interface IdentityApiEntityListByNameRequest {
    list: EntityListByNameListEnum;
}
export interface IdentityApiEntityListFromStorageRequest {
    list: EntityListFromStorageListEnum;
}
export interface IdentityApiEntityLookUpOperationRequest {
    entityLookUpRequest: EntityLookUpRequest;
}
export interface IdentityApiEntityMergeOperationRequest {
    entityMergeRequest: EntityMergeRequest;
}
export interface IdentityApiEntityReadAliasByIdRequest {
    id: string;
}
export interface IdentityApiEntityReadByIdRequest {
    id: string;
}
export interface IdentityApiEntityReadByNameRequest {
    name: string;
}
export interface IdentityApiEntityUpdateAliasByIdOperationRequest {
    id: string;
    entityUpdateAliasByIdRequest: EntityUpdateAliasByIdRequest;
}
export interface IdentityApiEntityUpdateByIdOperationRequest {
    id: string;
    entityUpdateByIdRequest: EntityUpdateByIdRequest;
}
export interface IdentityApiEntityUpdateByNameOperationRequest {
    name: string;
    entityUpdateByNameRequest: EntityUpdateByNameRequest;
}
export interface IdentityApiGroupCreateOperationRequest {
    groupCreateRequest: GroupCreateRequest;
}
export interface IdentityApiGroupCreateAliasOperationRequest {
    groupCreateAliasRequest: GroupCreateAliasRequest;
}
export interface IdentityApiGroupDeleteAliasByIdRequest {
    id: string;
}
export interface IdentityApiGroupDeleteByIdRequest {
    id: string;
}
export interface IdentityApiGroupDeleteByNameRequest {
    name: string;
}
export interface IdentityApiGroupListAliasesByIdRequest {
    list: GroupListAliasesByIdListEnum;
}
export interface IdentityApiGroupListByIdRequest {
    list: GroupListByIdListEnum;
}
export interface IdentityApiGroupListByNameRequest {
    list: GroupListByNameListEnum;
}
export interface IdentityApiGroupListFromStorageRequest {
    list: GroupListFromStorageListEnum;
}
export interface IdentityApiGroupLookUpOperationRequest {
    groupLookUpRequest: GroupLookUpRequest;
}
export interface IdentityApiGroupReadAliasByIdRequest {
    id: string;
}
export interface IdentityApiGroupReadByIdRequest {
    id: string;
}
export interface IdentityApiGroupReadByNameRequest {
    name: string;
}
export interface IdentityApiGroupUpdateAliasByIdOperationRequest {
    id: string;
    groupUpdateAliasByIdRequest: GroupUpdateAliasByIdRequest;
}
export interface IdentityApiGroupUpdateByIdOperationRequest {
    id: string;
    groupUpdateByIdRequest: GroupUpdateByIdRequest;
}
export interface IdentityApiGroupUpdateByNameOperationRequest {
    name: string;
    groupUpdateByNameRequest: GroupUpdateByNameRequest;
}
export interface IdentityApiGroupsCreateDuplicatesOperationRequest {
    groupsCreateDuplicatesRequest: GroupsCreateDuplicatesRequest;
}
export interface IdentityApiMfaAdminDestroyTotpSecretOperationRequest {
    mfaAdminDestroyTotpSecretRequest: MfaAdminDestroyTotpSecretRequest;
}
export interface IdentityApiMfaAdminGenerateTotpSecretOperationRequest {
    mfaAdminGenerateTotpSecretRequest: MfaAdminGenerateTotpSecretRequest;
}
export interface IdentityApiMfaCreateDuoMethodOperationRequest {
    mfaCreateDuoMethodRequest: MfaCreateDuoMethodRequest;
}
export interface IdentityApiMfaCreateOktaMethodOperationRequest {
    mfaCreateOktaMethodRequest: MfaCreateOktaMethodRequest;
}
export interface IdentityApiMfaCreatePingIdMethodOperationRequest {
    mfaCreatePingIdMethodRequest: MfaCreatePingIdMethodRequest;
}
export interface IdentityApiMfaCreateTotpMethodOperationRequest {
    mfaCreateTotpMethodRequest: MfaCreateTotpMethodRequest;
}
export interface IdentityApiMfaDeleteDuoMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaDeleteLoginEnforcementRequest {
    name: string;
}
export interface IdentityApiMfaDeleteOktaMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaDeletePingIdMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaDeleteTotpMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaGenerateTotpSecretOperationRequest {
    mfaGenerateTotpSecretRequest: MfaGenerateTotpSecretRequest;
}
export interface IdentityApiMfaListDuoMethodsRequest {
    list: MfaListDuoMethodsListEnum;
}
export interface IdentityApiMfaListLoginEnforcementsRequest {
    list: MfaListLoginEnforcementsListEnum;
}
export interface IdentityApiMfaListMethodsRequest {
    list: MfaListMethodsListEnum;
}
export interface IdentityApiMfaListOktaMethodsRequest {
    list: MfaListOktaMethodsListEnum;
}
export interface IdentityApiMfaListPingIdMethodsRequest {
    list: MfaListPingIdMethodsListEnum;
}
export interface IdentityApiMfaListTotpMethodsRequest {
    list: MfaListTotpMethodsListEnum;
}
export interface IdentityApiMfaReadDuoMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaReadLoginEnforcementRequest {
    name: string;
}
export interface IdentityApiMfaReadMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaReadOktaMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaReadPingIdMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaReadTotpMethodRequest {
    methodId: string;
}
export interface IdentityApiMfaUpdateDuoMethodOperationRequest {
    methodId: string;
    mfaUpdateDuoMethodRequest: MfaUpdateDuoMethodRequest;
}
export interface IdentityApiMfaUpdateOktaMethodOperationRequest {
    methodId: string;
    mfaUpdateOktaMethodRequest: MfaUpdateOktaMethodRequest;
}
export interface IdentityApiMfaUpdatePingIdMethodOperationRequest {
    methodId: string;
    mfaUpdatePingIdMethodRequest: MfaUpdatePingIdMethodRequest;
}
export interface IdentityApiMfaUpdateTotpMethodOperationRequest {
    methodId: string;
    mfaUpdateTotpMethodRequest: MfaUpdateTotpMethodRequest;
}
export interface IdentityApiMfaWriteLoginEnforcementOperationRequest {
    name: string;
    mfaWriteLoginEnforcementRequest: MfaWriteLoginEnforcementRequest;
}
export interface IdentityApiOidcConfigureOperationRequest {
    oidcConfigureRequest: OidcConfigureRequest;
}
export interface IdentityApiOidcDeleteAssignmentRequest {
    name: string;
}
export interface IdentityApiOidcDeleteClientRequest {
    name: string;
}
export interface IdentityApiOidcDeleteKeyRequest {
    name: string;
}
export interface IdentityApiOidcDeleteProviderRequest {
    name: string;
}
export interface IdentityApiOidcDeleteRoleRequest {
    name: string;
}
export interface IdentityApiOidcDeleteScopeRequest {
    name: string;
}
export interface IdentityApiOidcGenerateTokenRequest {
    name: string;
}
export interface IdentityApiOidcIntrospectOperationRequest {
    oidcIntrospectRequest: OidcIntrospectRequest;
}
export interface IdentityApiOidcListAssignmentsRequest {
    list: OidcListAssignmentsListEnum;
}
export interface IdentityApiOidcListClientsRequest {
    list: OidcListClientsListEnum;
}
export interface IdentityApiOidcListKeysRequest {
    list: OidcListKeysListEnum;
}
export interface IdentityApiOidcListProvidersRequest {
    list: OidcListProvidersListEnum;
    allowedClientId?: string;
}
export interface IdentityApiOidcListRolesRequest {
    list: OidcListRolesListEnum;
}
export interface IdentityApiOidcListScopesRequest {
    list: OidcListScopesListEnum;
}
export interface IdentityApiOidcProviderAuthorizeRequest {
    name: string;
    clientId?: string;
    codeChallenge?: string;
    codeChallengeMethod?: string;
    maxAge?: number;
    nonce?: string;
    redirectUri?: string;
    responseType?: string;
    scope?: string;
    state?: string;
}
export interface IdentityApiOidcProviderAuthorizeWithParametersOperationRequest {
    name: string;
    oidcProviderAuthorizeWithParametersRequest: OidcProviderAuthorizeWithParametersRequest;
}
export interface IdentityApiOidcProviderTokenOperationRequest {
    name: string;
    oidcProviderTokenRequest: OidcProviderTokenRequest;
}
export interface IdentityApiOidcProviderUserInfoRequest {
    name: string;
}
export interface IdentityApiOidcProviderUserInfo2Request {
    name: string;
}
export interface IdentityApiOidcReadAssignmentRequest {
    name: string;
}
export interface IdentityApiOidcReadClientRequest {
    name: string;
}
export interface IdentityApiOidcReadKeyRequest {
    name: string;
}
export interface IdentityApiOidcReadOidcChildWellKnownKeysRequest {
    child: string;
}
export interface IdentityApiOidcReadOidcChildWellKnownOpenidConfigurationRequest {
    child: string;
}
export interface IdentityApiOidcReadProviderRequest {
    name: string;
}
export interface IdentityApiOidcReadProviderOpenIdConfigurationRequest {
    name: string;
}
export interface IdentityApiOidcReadProviderPublicKeysRequest {
    name: string;
}
export interface IdentityApiOidcReadRoleRequest {
    name: string;
}
export interface IdentityApiOidcReadScopeRequest {
    name: string;
}
export interface IdentityApiOidcRotateKeyOperationRequest {
    name: string;
    oidcRotateKeyRequest: OidcRotateKeyRequest;
}
export interface IdentityApiOidcWriteAssignmentOperationRequest {
    name: string;
    oidcWriteAssignmentRequest: OidcWriteAssignmentRequest;
}
export interface IdentityApiOidcWriteClientOperationRequest {
    name: string;
    oidcWriteClientRequest: OidcWriteClientRequest;
}
export interface IdentityApiOidcWriteKeyOperationRequest {
    name: string;
    oidcWriteKeyRequest: OidcWriteKeyRequest;
}
export interface IdentityApiOidcWriteProviderOperationRequest {
    name: string;
    oidcWriteProviderRequest: OidcWriteProviderRequest;
}
export interface IdentityApiOidcWriteRoleOperationRequest {
    name: string;
    oidcWriteRoleRequest: OidcWriteRoleRequest;
}
export interface IdentityApiOidcWriteScopeOperationRequest {
    name: string;
    oidcWriteScopeRequest: OidcWriteScopeRequest;
}
export interface IdentityApiPersonaCreateOperationRequest {
    personaCreateRequest: PersonaCreateRequest;
}
export interface IdentityApiPersonaDeleteByIdRequest {
    id: string;
}
export interface IdentityApiPersonaListByIdRequest {
    list: PersonaListByIdListEnum;
}
export interface IdentityApiPersonaReadByIdRequest {
    id: string;
}
export interface IdentityApiPersonaUpdateByIdOperationRequest {
    id: string;
    personaUpdateByIdRequest: PersonaUpdateByIdRequest;
}
/**
 *
 */
export declare class IdentityApi extends runtime.BaseAPI {
    /**
     * Create a new alias.
     */
    aliasCreateRaw(requestParameters: IdentityApiAliasCreateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a new alias.
     */
    aliasCreate(aliasCreateRequest: AliasCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    aliasDeleteByIdRaw(requestParameters: IdentityApiAliasDeleteByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    aliasDeleteById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List all the alias IDs.
     */
    aliasListByIdRaw(requestParameters: IdentityApiAliasListByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List all the alias IDs.
     */
    aliasListById(list: AliasListByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    aliasReadByIdRaw(requestParameters: IdentityApiAliasReadByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    aliasReadById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    aliasUpdateByIdRaw(requestParameters: IdentityApiAliasUpdateByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    aliasUpdateById(id: string, aliasUpdateByIdRequest: AliasUpdateByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entitiesCreateDuplicatesRaw(requestParameters: IdentityApiEntitiesCreateDuplicatesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entitiesCreateDuplicates(entitiesCreateDuplicatesRequest: EntitiesCreateDuplicatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityAliasCreateDuplicatesRaw(requestParameters: IdentityApiEntityAliasCreateDuplicatesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityAliasCreateDuplicates(entityAliasCreateDuplicatesRequest: EntityAliasCreateDuplicatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityAliasesCreateDuplicatesRaw(requestParameters: IdentityApiEntityAliasesCreateDuplicatesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityAliasesCreateDuplicates(entityAliasesCreateDuplicatesRequest: EntityAliasesCreateDuplicatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityBatchDeleteRaw(requestParameters: IdentityApiEntityBatchDeleteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityBatchDelete(entityBatchDeleteRequest: EntityBatchDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityCreateRaw(requestParameters: IdentityApiEntityCreateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityCreate(entityCreateRequest: EntityCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a new alias.
     */
    entityCreateAliasRaw(requestParameters: IdentityApiEntityCreateAliasOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a new alias.
     */
    entityCreateAlias(entityCreateAliasRequest: EntityCreateAliasRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityDeleteAliasByIdRaw(requestParameters: IdentityApiEntityDeleteAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityDeleteAliasById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityDeleteByIdRaw(requestParameters: IdentityApiEntityDeleteByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityDeleteById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityDeleteByNameRaw(requestParameters: IdentityApiEntityDeleteByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityDeleteByName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List all the alias IDs.
     */
    entityListAliasesByIdRaw(requestParameters: IdentityApiEntityListAliasesByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List all the alias IDs.
     */
    entityListAliasesById(list: EntityListAliasesByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    entityListByIdRaw(requestParameters: IdentityApiEntityListByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    entityListById(list: EntityListByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    entityListByNameRaw(requestParameters: IdentityApiEntityListByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    entityListByName(list: EntityListByNameListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    entityListFromStorageRaw(requestParameters: IdentityApiEntityListFromStorageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    entityListFromStorage(list: EntityListFromStorageListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Query entities based on various properties.
     */
    entityLookUpRaw(requestParameters: IdentityApiEntityLookUpOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Query entities based on various properties.
     */
    entityLookUp(entityLookUpRequest: EntityLookUpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityMergeRaw(requestParameters: IdentityApiEntityMergeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityMerge(entityMergeRequest: EntityMergeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityReadAliasByIdRaw(requestParameters: IdentityApiEntityReadAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityReadAliasById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityReadByIdRaw(requestParameters: IdentityApiEntityReadByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityReadById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityReadByNameRaw(requestParameters: IdentityApiEntityReadByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityReadByName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityUpdateAliasByIdRaw(requestParameters: IdentityApiEntityUpdateAliasByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityUpdateAliasById(id: string, entityUpdateAliasByIdRequest: EntityUpdateAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityUpdateByIdRaw(requestParameters: IdentityApiEntityUpdateByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityUpdateById(id: string, entityUpdateByIdRequest: EntityUpdateByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    entityUpdateByNameRaw(requestParameters: IdentityApiEntityUpdateByNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    entityUpdateByName(name: string, entityUpdateByNameRequest: EntityUpdateByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupCreateRaw(requestParameters: IdentityApiGroupCreateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupCreate(groupCreateRequest: GroupCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupCreateAliasRaw(requestParameters: IdentityApiGroupCreateAliasOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupCreateAlias(groupCreateAliasRequest: GroupCreateAliasRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupDeleteAliasByIdRaw(requestParameters: IdentityApiGroupDeleteAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupDeleteAliasById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupDeleteByIdRaw(requestParameters: IdentityApiGroupDeleteByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupDeleteById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupDeleteByNameRaw(requestParameters: IdentityApiGroupDeleteByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupDeleteByName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List all the group alias IDs.
     */
    groupListAliasesByIdRaw(requestParameters: IdentityApiGroupListAliasesByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List all the group alias IDs.
     */
    groupListAliasesById(list: GroupListAliasesByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List all the group IDs.
     */
    groupListByIdRaw(requestParameters: IdentityApiGroupListByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List all the group IDs.
     */
    groupListById(list: GroupListByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    groupListByNameRaw(requestParameters: IdentityApiGroupListByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    groupListByName(list: GroupListByNameListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    groupListFromStorageRaw(requestParameters: IdentityApiGroupListFromStorageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    groupListFromStorage(list: GroupListFromStorageListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Query groups based on various properties.
     */
    groupLookUpRaw(requestParameters: IdentityApiGroupLookUpOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Query groups based on various properties.
     */
    groupLookUp(groupLookUpRequest: GroupLookUpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupReadAliasByIdRaw(requestParameters: IdentityApiGroupReadAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupReadAliasById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupReadByIdRaw(requestParameters: IdentityApiGroupReadByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupReadById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupReadByNameRaw(requestParameters: IdentityApiGroupReadByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupReadByName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupUpdateAliasByIdRaw(requestParameters: IdentityApiGroupUpdateAliasByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupUpdateAliasById(id: string, groupUpdateAliasByIdRequest: GroupUpdateAliasByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupUpdateByIdRaw(requestParameters: IdentityApiGroupUpdateByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupUpdateById(id: string, groupUpdateByIdRequest: GroupUpdateByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupUpdateByNameRaw(requestParameters: IdentityApiGroupUpdateByNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupUpdateByName(name: string, groupUpdateByNameRequest: GroupUpdateByNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    groupsCreateDuplicatesRaw(requestParameters: IdentityApiGroupsCreateDuplicatesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    groupsCreateDuplicates(groupsCreateDuplicatesRequest: GroupsCreateDuplicatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Destroys a TOTP secret for the given MFA method ID on the given entity
     */
    mfaAdminDestroyTotpSecretRaw(requestParameters: IdentityApiMfaAdminDestroyTotpSecretOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Destroys a TOTP secret for the given MFA method ID on the given entity
     */
    mfaAdminDestroyTotpSecret(mfaAdminDestroyTotpSecretRequest: MfaAdminDestroyTotpSecretRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update or create TOTP secret for the given method ID on the given entity.
     */
    mfaAdminGenerateTotpSecretRaw(requestParameters: IdentityApiMfaAdminGenerateTotpSecretOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update or create TOTP secret for the given method ID on the given entity.
     */
    mfaAdminGenerateTotpSecret(mfaAdminGenerateTotpSecretRequest: MfaAdminGenerateTotpSecretRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create the given MFA method
     */
    mfaCreateDuoMethodRaw(requestParameters: IdentityApiMfaCreateDuoMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create the given MFA method
     */
    mfaCreateDuoMethod(mfaCreateDuoMethodRequest: MfaCreateDuoMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create the given MFA method
     */
    mfaCreateOktaMethodRaw(requestParameters: IdentityApiMfaCreateOktaMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create the given MFA method
     */
    mfaCreateOktaMethod(mfaCreateOktaMethodRequest: MfaCreateOktaMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create the given MFA method
     */
    mfaCreatePingIdMethodRaw(requestParameters: IdentityApiMfaCreatePingIdMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create the given MFA method
     */
    mfaCreatePingIdMethod(mfaCreatePingIdMethodRequest: MfaCreatePingIdMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create the given MFA method
     */
    mfaCreateTotpMethodRaw(requestParameters: IdentityApiMfaCreateTotpMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create the given MFA method
     */
    mfaCreateTotpMethod(mfaCreateTotpMethodRequest: MfaCreateTotpMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteDuoMethodRaw(requestParameters: IdentityApiMfaDeleteDuoMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteDuoMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete a login enforcement
     */
    mfaDeleteLoginEnforcementRaw(requestParameters: IdentityApiMfaDeleteLoginEnforcementRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete a login enforcement
     */
    mfaDeleteLoginEnforcement(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteOktaMethodRaw(requestParameters: IdentityApiMfaDeleteOktaMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteOktaMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the given MFA method
     */
    mfaDeletePingIdMethodRaw(requestParameters: IdentityApiMfaDeletePingIdMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the given MFA method
     */
    mfaDeletePingIdMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteTotpMethodRaw(requestParameters: IdentityApiMfaDeleteTotpMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the given MFA method
     */
    mfaDeleteTotpMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update or create TOTP secret for the given method ID on the given entity.
     */
    mfaGenerateTotpSecretRaw(requestParameters: IdentityApiMfaGenerateTotpSecretOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update or create TOTP secret for the given method ID on the given entity.
     */
    mfaGenerateTotpSecret(mfaGenerateTotpSecretRequest: MfaGenerateTotpSecretRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListDuoMethodsRaw(requestParameters: IdentityApiMfaListDuoMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListDuoMethods(list: MfaListDuoMethodsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List login enforcements
     */
    mfaListLoginEnforcementsRaw(requestParameters: IdentityApiMfaListLoginEnforcementsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List login enforcements
     */
    mfaListLoginEnforcements(list: MfaListLoginEnforcementsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List MFA method configurations for all MFA methods
     */
    mfaListMethodsRaw(requestParameters: IdentityApiMfaListMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List MFA method configurations for all MFA methods
     */
    mfaListMethods(list: MfaListMethodsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListOktaMethodsRaw(requestParameters: IdentityApiMfaListOktaMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListOktaMethods(list: MfaListOktaMethodsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListPingIdMethodsRaw(requestParameters: IdentityApiMfaListPingIdMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListPingIdMethods(list: MfaListPingIdMethodsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListTotpMethodsRaw(requestParameters: IdentityApiMfaListTotpMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List MFA method configurations for the given MFA method
     */
    mfaListTotpMethods(list: MfaListTotpMethodsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadDuoMethodRaw(requestParameters: IdentityApiMfaReadDuoMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadDuoMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current login enforcement
     */
    mfaReadLoginEnforcementRaw(requestParameters: IdentityApiMfaReadLoginEnforcementRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current login enforcement
     */
    mfaReadLoginEnforcement(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current configuration for the given ID regardless of the MFA method type
     */
    mfaReadMethodRaw(requestParameters: IdentityApiMfaReadMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current configuration for the given ID regardless of the MFA method type
     */
    mfaReadMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadOktaMethodRaw(requestParameters: IdentityApiMfaReadOktaMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadOktaMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadPingIdMethodRaw(requestParameters: IdentityApiMfaReadPingIdMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadPingIdMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadTotpMethodRaw(requestParameters: IdentityApiMfaReadTotpMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current configuration for the given MFA method
     */
    mfaReadTotpMethod(methodId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateDuoMethodRaw(requestParameters: IdentityApiMfaUpdateDuoMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateDuoMethod(methodId: string, mfaUpdateDuoMethodRequest: MfaUpdateDuoMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateOktaMethodRaw(requestParameters: IdentityApiMfaUpdateOktaMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateOktaMethod(methodId: string, mfaUpdateOktaMethodRequest: MfaUpdateOktaMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdatePingIdMethodRaw(requestParameters: IdentityApiMfaUpdatePingIdMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdatePingIdMethod(methodId: string, mfaUpdatePingIdMethodRequest: MfaUpdatePingIdMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateTotpMethodRaw(requestParameters: IdentityApiMfaUpdateTotpMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the configuration for the given MFA method
     */
    mfaUpdateTotpMethod(methodId: string, mfaUpdateTotpMethodRequest: MfaUpdateTotpMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create or update a login enforcement
     */
    mfaWriteLoginEnforcementRaw(requestParameters: IdentityApiMfaWriteLoginEnforcementOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create or update a login enforcement
     */
    mfaWriteLoginEnforcement(name: string, mfaWriteLoginEnforcementRequest: MfaWriteLoginEnforcementRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcConfigureRaw(requestParameters: IdentityApiOidcConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcConfigure(oidcConfigureRequest: OidcConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcDeleteAssignmentRaw(requestParameters: IdentityApiOidcDeleteAssignmentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcDeleteAssignment(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcDeleteClientRaw(requestParameters: IdentityApiOidcDeleteClientRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcDeleteClient(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcDeleteKeyRaw(requestParameters: IdentityApiOidcDeleteKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcDeleteKey(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcDeleteProviderRaw(requestParameters: IdentityApiOidcDeleteProviderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcDeleteProvider(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcDeleteRoleRaw(requestParameters: IdentityApiOidcDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcDeleteRole(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcDeleteScopeRaw(requestParameters: IdentityApiOidcDeleteScopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcDeleteScope(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Generate an OIDC token
     */
    oidcGenerateTokenRaw(requestParameters: IdentityApiOidcGenerateTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Generate an OIDC token
     */
    oidcGenerateToken(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Verify the authenticity of an OIDC token
     */
    oidcIntrospectRaw(requestParameters: IdentityApiOidcIntrospectOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Verify the authenticity of an OIDC token
     */
    oidcIntrospect(oidcIntrospectRequest: OidcIntrospectRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcListAssignmentsRaw(requestParameters: IdentityApiOidcListAssignmentsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    oidcListAssignments(list: OidcListAssignmentsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    oidcListClientsRaw(requestParameters: IdentityApiOidcListClientsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    oidcListClients(list: OidcListClientsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List OIDC keys
     */
    oidcListKeysRaw(requestParameters: IdentityApiOidcListKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List OIDC keys
     */
    oidcListKeys(list: OidcListKeysListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    oidcListProvidersRaw(requestParameters: IdentityApiOidcListProvidersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    oidcListProviders(list: OidcListProvidersListEnum, allowedClientId?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List configured OIDC roles
     */
    oidcListRolesRaw(requestParameters: IdentityApiOidcListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List configured OIDC roles
     */
    oidcListRoles(list: OidcListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    oidcListScopesRaw(requestParameters: IdentityApiOidcListScopesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    oidcListScopes(list: OidcListScopesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    oidcProviderAuthorizeRaw(requestParameters: IdentityApiOidcProviderAuthorizeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcProviderAuthorize(name: string, clientId?: string, codeChallenge?: string, codeChallengeMethod?: string, maxAge?: number, nonce?: string, redirectUri?: string, responseType?: string, scope?: string, state?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcProviderAuthorizeWithParametersRaw(requestParameters: IdentityApiOidcProviderAuthorizeWithParametersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcProviderAuthorizeWithParameters(name: string, oidcProviderAuthorizeWithParametersRequest: OidcProviderAuthorizeWithParametersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcProviderTokenRaw(requestParameters: IdentityApiOidcProviderTokenOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcProviderToken(name: string, oidcProviderTokenRequest: OidcProviderTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcProviderUserInfoRaw(requestParameters: IdentityApiOidcProviderUserInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcProviderUserInfo(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcProviderUserInfo2Raw(requestParameters: IdentityApiOidcProviderUserInfo2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcProviderUserInfo2(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadAssignmentRaw(requestParameters: IdentityApiOidcReadAssignmentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadAssignment(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadClientRaw(requestParameters: IdentityApiOidcReadClientRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadClient(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcReadKeyRaw(requestParameters: IdentityApiOidcReadKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcReadKey(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Retrieve public keys
     */
    oidcReadOidcChildWellKnownKeysRaw(requestParameters: IdentityApiOidcReadOidcChildWellKnownKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Retrieve public keys
     */
    oidcReadOidcChildWellKnownKeys(child: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Query OIDC configurations
     */
    oidcReadOidcChildWellKnownOpenidConfigurationRaw(requestParameters: IdentityApiOidcReadOidcChildWellKnownOpenidConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Query OIDC configurations
     */
    oidcReadOidcChildWellKnownOpenidConfiguration(child: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Query OIDC configurations
     */
    oidcReadOpenIdConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Query OIDC configurations
     */
    oidcReadOpenIdConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadProviderRaw(requestParameters: IdentityApiOidcReadProviderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadProvider(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadProviderOpenIdConfigurationRaw(requestParameters: IdentityApiOidcReadProviderOpenIdConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadProviderOpenIdConfiguration(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadProviderPublicKeysRaw(requestParameters: IdentityApiOidcReadProviderPublicKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadProviderPublicKeys(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Retrieve public keys
     */
    oidcReadPublicKeysRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Retrieve public keys
     */
    oidcReadPublicKeys(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcReadRoleRaw(requestParameters: IdentityApiOidcReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcReadRole(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcReadScopeRaw(requestParameters: IdentityApiOidcReadScopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcReadScope(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Rotate a named OIDC key.
     */
    oidcRotateKeyRaw(requestParameters: IdentityApiOidcRotateKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Rotate a named OIDC key.
     */
    oidcRotateKey(name: string, oidcRotateKeyRequest: OidcRotateKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcWriteAssignmentRaw(requestParameters: IdentityApiOidcWriteAssignmentOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcWriteAssignment(name: string, oidcWriteAssignmentRequest: OidcWriteAssignmentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcWriteClientRaw(requestParameters: IdentityApiOidcWriteClientOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcWriteClient(name: string, oidcWriteClientRequest: OidcWriteClientRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcWriteKeyRaw(requestParameters: IdentityApiOidcWriteKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations for OIDC keys.
     */
    oidcWriteKey(name: string, oidcWriteKeyRequest: OidcWriteKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcWriteProviderRaw(requestParameters: IdentityApiOidcWriteProviderOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcWriteProvider(name: string, oidcWriteProviderRequest: OidcWriteProviderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcWriteRoleRaw(requestParameters: IdentityApiOidcWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * CRUD operations on OIDC Roles
     */
    oidcWriteRole(name: string, oidcWriteRoleRequest: OidcWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oidcWriteScopeRaw(requestParameters: IdentityApiOidcWriteScopeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oidcWriteScope(name: string, oidcWriteScopeRequest: OidcWriteScopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a new alias.
     */
    personaCreateRaw(requestParameters: IdentityApiPersonaCreateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a new alias.
     */
    personaCreate(personaCreateRequest: PersonaCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    personaDeleteByIdRaw(requestParameters: IdentityApiPersonaDeleteByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    personaDeleteById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List all the alias IDs.
     */
    personaListByIdRaw(requestParameters: IdentityApiPersonaListByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List all the alias IDs.
     */
    personaListById(list: PersonaListByIdListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    personaReadByIdRaw(requestParameters: IdentityApiPersonaReadByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    personaReadById(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    personaUpdateByIdRaw(requestParameters: IdentityApiPersonaUpdateByIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    personaUpdateById(id: string, personaUpdateByIdRequest: PersonaUpdateByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
}
/**
  * @export
  * @enum {string}
  */
export declare enum AliasListByIdListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum EntityListAliasesByIdListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum EntityListByIdListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum EntityListByNameListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum EntityListFromStorageListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GroupListAliasesByIdListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GroupListByIdListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GroupListByNameListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GroupListFromStorageListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListDuoMethodsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListLoginEnforcementsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListMethodsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListOktaMethodsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListPingIdMethodsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum MfaListTotpMethodsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListAssignmentsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListClientsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListKeysListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListProvidersListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OidcListScopesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PersonaListByIdListEnum {
    TRUE = "true"
}
