/* compat.c -- Missing functions replacements and others.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

#if !HAVE_STDLIB_H
extern PTR EXFUN (malloc, (size_t size));
extern void EXFUN (free, (PTR ptr));
#endif
     
PTR
DEFUN (xmalloc, (size),
       size_t size)
{
  PTR ptr = malloc (size);

  if (ptr == 0)
    {
      fputs (_("Out of memory!\n"), stderr);
      exit (1);
    }
  return ptr;
}

void
DEFUN (xfree, (ptr),
       PTR ptr)
{
  if (ptr)
    free (ptr);
}

char *
DEFUN (savestring, (string),
       CONST char *string)
{
  char *tmp = (char *) xmalloc (strlen (string) + 1);

  return strcpy (tmp, string);
}

/* these are needed by libintl.a stuff... */
char *
DEFUN (xstrdup, (string),
       CONST char *string)
{
  char *tmp = (char *) xmalloc (strlen (string) + 1);

  return strcpy (tmp, string);
}

void
DEFUN (error, (fatal, errnum, errmsg),
       int fatal AND int errnum AND CONST char * errmsg)
{
  LOG("%s", errmsg);
  if (fatal)
    exit (errnum);
}

#if !HAVE_GETHOSTNAME

/*
 * From Cnews as of 1 Jan 91
 *
 * Uglix gethostname simulation
 */

#include <sys/types.h>
#include <sys/utsname.h>

#define min(a, b) ((a) < (b)? (a): (b))

int
DEFUN (gethostname, (buf, size),
       char *buf AND
       int size)
{
  struct utsname ugnm;
  char *strncpy ();

  if (uname (&ugnm) < 0)
    return -1;
  (void) strncpy (buf, ugnm.nodename, min (sizeof ugnm.nodename, size));
  return 0;
}

#endif /* !HAVE_GETHOSTNAME */

#if !HAVE_GETDOMAINNAME

int
DEFUN (getdomainname, (buf, size),
       char * buf AND int size)
{
  strcpy (buf, NET_DOMAIN);
  return 0;
}

#endif /* !HAVE_GETDOMAINNAME */
