/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	triggersv1beta1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// TriggerTemplatesGetter has a method to return a TriggerTemplateInterface.
// A group's client should implement this interface.
type TriggerTemplatesGetter interface {
	TriggerTemplates(namespace string) TriggerTemplateInterface
}

// TriggerTemplateInterface has methods to work with TriggerTemplate resources.
type TriggerTemplateInterface interface {
	Create(ctx context.Context, triggerTemplate *triggersv1beta1.TriggerTemplate, opts v1.CreateOptions) (*triggersv1beta1.TriggerTemplate, error)
	Update(ctx context.Context, triggerTemplate *triggersv1beta1.TriggerTemplate, opts v1.UpdateOptions) (*triggersv1beta1.TriggerTemplate, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, triggerTemplate *triggersv1beta1.TriggerTemplate, opts v1.UpdateOptions) (*triggersv1beta1.TriggerTemplate, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*triggersv1beta1.TriggerTemplate, error)
	List(ctx context.Context, opts v1.ListOptions) (*triggersv1beta1.TriggerTemplateList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *triggersv1beta1.TriggerTemplate, err error)
	TriggerTemplateExpansion
}

// triggerTemplates implements TriggerTemplateInterface
type triggerTemplates struct {
	*gentype.ClientWithList[*triggersv1beta1.TriggerTemplate, *triggersv1beta1.TriggerTemplateList]
}

// newTriggerTemplates returns a TriggerTemplates
func newTriggerTemplates(c *TriggersV1beta1Client, namespace string) *triggerTemplates {
	return &triggerTemplates{
		gentype.NewClientWithList[*triggersv1beta1.TriggerTemplate, *triggersv1beta1.TriggerTemplateList](
			"triggertemplates",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *triggersv1beta1.TriggerTemplate { return &triggersv1beta1.TriggerTemplate{} },
			func() *triggersv1beta1.TriggerTemplateList { return &triggersv1beta1.TriggerTemplateList{} },
		),
	}
}
