/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	triggersv1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// InterceptorsGetter has a method to return a InterceptorInterface.
// A group's client should implement this interface.
type InterceptorsGetter interface {
	Interceptors(namespace string) InterceptorInterface
}

// InterceptorInterface has methods to work with Interceptor resources.
type InterceptorInterface interface {
	Create(ctx context.Context, interceptor *triggersv1alpha1.Interceptor, opts v1.CreateOptions) (*triggersv1alpha1.Interceptor, error)
	Update(ctx context.Context, interceptor *triggersv1alpha1.Interceptor, opts v1.UpdateOptions) (*triggersv1alpha1.Interceptor, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, interceptor *triggersv1alpha1.Interceptor, opts v1.UpdateOptions) (*triggersv1alpha1.Interceptor, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*triggersv1alpha1.Interceptor, error)
	List(ctx context.Context, opts v1.ListOptions) (*triggersv1alpha1.InterceptorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *triggersv1alpha1.Interceptor, err error)
	InterceptorExpansion
}

// interceptors implements InterceptorInterface
type interceptors struct {
	*gentype.ClientWithList[*triggersv1alpha1.Interceptor, *triggersv1alpha1.InterceptorList]
}

// newInterceptors returns a Interceptors
func newInterceptors(c *TriggersV1alpha1Client, namespace string) *interceptors {
	return &interceptors{
		gentype.NewClientWithList[*triggersv1alpha1.Interceptor, *triggersv1alpha1.InterceptorList](
			"interceptors",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *triggersv1alpha1.Interceptor { return &triggersv1alpha1.Interceptor{} },
			func() *triggersv1alpha1.InterceptorList { return &triggersv1alpha1.InterceptorList{} },
		),
	}
}
