/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	triggersv1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterInterceptorsGetter has a method to return a ClusterInterceptorInterface.
// A group's client should implement this interface.
type ClusterInterceptorsGetter interface {
	ClusterInterceptors() ClusterInterceptorInterface
}

// ClusterInterceptorInterface has methods to work with ClusterInterceptor resources.
type ClusterInterceptorInterface interface {
	Create(ctx context.Context, clusterInterceptor *triggersv1alpha1.ClusterInterceptor, opts v1.CreateOptions) (*triggersv1alpha1.ClusterInterceptor, error)
	Update(ctx context.Context, clusterInterceptor *triggersv1alpha1.ClusterInterceptor, opts v1.UpdateOptions) (*triggersv1alpha1.ClusterInterceptor, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, clusterInterceptor *triggersv1alpha1.ClusterInterceptor, opts v1.UpdateOptions) (*triggersv1alpha1.ClusterInterceptor, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*triggersv1alpha1.ClusterInterceptor, error)
	List(ctx context.Context, opts v1.ListOptions) (*triggersv1alpha1.ClusterInterceptorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *triggersv1alpha1.ClusterInterceptor, err error)
	ClusterInterceptorExpansion
}

// clusterInterceptors implements ClusterInterceptorInterface
type clusterInterceptors struct {
	*gentype.ClientWithList[*triggersv1alpha1.ClusterInterceptor, *triggersv1alpha1.ClusterInterceptorList]
}

// newClusterInterceptors returns a ClusterInterceptors
func newClusterInterceptors(c *TriggersV1alpha1Client) *clusterInterceptors {
	return &clusterInterceptors{
		gentype.NewClientWithList[*triggersv1alpha1.ClusterInterceptor, *triggersv1alpha1.ClusterInterceptorList](
			"clusterinterceptors",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *triggersv1alpha1.ClusterInterceptor { return &triggersv1alpha1.ClusterInterceptor{} },
			func() *triggersv1alpha1.ClusterInterceptorList { return &triggersv1alpha1.ClusterInterceptorList{} },
		),
	}
}
